package cn.smarthse.fwgj.model.vo;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 *
 * 移动端：风险详情vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/3/8 11:05
 */
@Data
public class ReformDetailVo implements Serializable {

    private static final long serialVersionUID = 5747305091343794048L;

//@ApiModelProperty("风险id")
    private Long reformId;

//@ApiModelProperty("reform_item_basic.id")
    private Long basicId;

//@ApiModelProperty("单位id")
    private Long cid;

//@ApiModelProperty("风险名/对应工作")
    private String reformName;

    /**
     * 风险发现人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String finderName;

//@ApiModelProperty("推送时间")
    private Date findTime;

//@ApiModelProperty("推送时间")
    private String findTimeStr;

//@ApiModelProperty("无需推送（备注）")
    private String findTimeRemark;

//@ApiModelProperty("风险识别时间（创建时间）")
    private Date createDate;

//@ApiModelProperty("风险来源(防治责任自查-1; 第三方托管核查-2; 职业健康体检-3; 职业病危害因素检测-4; 在线监测-5; 在线监控-6; 乡镇协管-7 关键因素画像-8 服务管家-9 ReformSourceLiteEnum)")
    private Byte reformItemSource;

//@ApiModelProperty("风险等级（一般事故隐患现场立即整改-1; 一般事故隐患限期整改-2; 重大事故隐患停产停业整顿-3 ReformItemLevelEnum）")
    private Integer reformItemLevel;

//@ApiModelProperty("隐患分类(管理类-1; 从业人员类-2; 设备设施及物料类-3; 场所环境类-4 ReformItemTypeEnum)")
    private Integer reformItemType;

//@ApiModelProperty("风险描述")
    private String description;

//@ApiModelProperty("生成来源(巡查包括10, 12, 13, 14, 15, 16, 17, 18) ReformGenerationSourceEnum")
    private Integer generationSource;

//@ApiModelProperty("状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）)")
    private Byte status;

//@ApiModelProperty("风险来源下拉")
    private List<ReformItemSource> reformItemSourceList;

//@ApiModelProperty("风险整改验收记录")
    List<ReformRecordDetailVo> reformRecordList;

//@ApiModelProperty("单位信息（乡镇协管的是巡查信息，风险画像的是企业信息）")
    PatrolInfoVo comany;

    public String getCreateDateStr() {
        return createDate != null ? DateUtil.format(createDate, "yyyy-MM-dd") : null;
    }
}
