
package cn.smarthse.fwgj.model.vo;

import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 新增巡查记录参数(企业信息部分)
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class PatrolInfoVo implements Serializable{
	private static final long serialVersionUID = 919743846229812934L;

	/**
	 * 巡查记录id
	 */
	//@ApiModelProperty="巡查记录id")
	private Long id;

	/**
	 * 巡查名称
	 */
	//@ApiModelProperty="巡查名称")
	private String patrolName;
	
	/**
	 * 单位id
	 */
    //@ApiModelProperty="单位id")
	private Long cid;
	
	/**
	 * 单位名称
	 */
    //@ApiModelProperty="单位名称")
	private String unitName;
	
	/**
	 * 单位营业状态
	 */
    //@ApiModelProperty="单位营业状态")
	private Integer unitStatus;
	
	/**
	 * 主要负责人
	 */
    //@ApiModelProperty="主要负责人")
	private String manager;
	
	/**
	 * 联系电话
	 */
    //@ApiModelProperty="联系电话")
	private String tel;
	
	/**
	 * 职业健康管理人员
	 */
    //@ApiModelProperty="职业健康管理人员")
	private String hseManager;
	
	/**
	 * 职业健康管理人员-联系电话
	 */
    //@ApiModelProperty="职业健康管理人员-联系电话")
	private String hesTel;
	
	/**
	 * 行政区划地址
	 */
    //@ApiModelProperty="行政区划地址")
	private String address;
	
	/**
	 * 工作场所地址
	 */
    //@ApiModelProperty="工作场所地址")
	private String workAddress;
	
	/**
	 * 行政区划
	 */
    //@ApiModelProperty="行政区划")
	private Long areaId;
	
	/**
	 * 行业编码
	 */
    //@ApiModelProperty="行业编码")
	private String industryCode;
	
	/**
	 * 行业名
	 */
    //@ApiModelProperty="行业名")
	private String industryName;
	
	/**
	 * 规模
	 */
    //@ApiModelProperty="规模")
	private String scaleCode;

	/**
	 * 规模名称
	 */
	//@ApiModelProperty="规模名称")
	private String scaleName;
	
	/**
	 * 经济
	 */
    //@ApiModelProperty="经济")
	private String economyCode;

	/**
	 * 经济名称
	 */
	//@ApiModelProperty="经济名称")
	private String economyName;
	
	/**
	 * 巡查年份
	 */
    //@ApiModelProperty="巡查年份")
	private Integer year;
	
	/**
	 * 巡查人
	 */
    //@ApiModelProperty="巡查人")
	private String patrolPeople;
	
	/**
	 * 巡查时间
	 */
    //@ApiModelProperty="巡查时间")
	private Date patrolTime;
	
	/**
	 * 巡查痕迹附件
	 */
    //@ApiModelProperty="巡查痕迹附件")
	private String checkFile;

	/**
	 * 巡查痕迹附件Url
	 */
	//@ApiModelProperty="巡查痕迹附件Url")
	private List<SysFileModel> checkFileUrl;

	/**
	 * 企业负责人签字
	 */
	//@ApiModelProperty="企业负责人签字")
	private Long unitManageSign;

	/**
	 * 指导员姓名
	 */
	//@ApiModelProperty="指导员姓名")
	private String guidePeople;

	/**
	 * 企业负责人签字Url
	 */
	//@ApiModelProperty="企业负责人签字Url")
	private String unitManageSignUrl;

	/**
	 * 巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)
	 */
	//@ApiModelProperty="巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已中止)")
	private Integer patrolStatus;

	/**
	 * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
	 */
	//@ApiModelProperty="中止类型(1-企业暂停；2-企业关闭；3-区域变更)")
	private Integer stopType;

	public String getScaleName() {
		if (scaleCode != null){
			return CompanySizeEnum.getName(Integer.valueOf(scaleCode));
		} else {
			return null;
		}
	}

}
