
package cn.smarthse.fwgj.model.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 辖区企业vo
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CompanyListVo implements Serializable{
	private static final long serialVersionUID = 8592916736369570275L;

	/**
	 * 签约id
	 */
	private Long customerId;

	/**
	 * 公司id
	 */
	private Long id;
	
	/**
	 * 公司名称
	 */
	private String name;

	/**
	 * 统一社会信用代码
	 */
	private String unifiedSocialCc;

	/**
	 * 公司地址
	 */
	private String address;

	/**
	 * 经度
	 */
	private String lng;

	/**
	 * 纬度
	 */
	private String lat;

	/**
	 * 职业卫生负责人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String mainLeaderName;

	/**
	 * 职业卫生负责人联系电话
	 */
	@Desensitization(type = DesensitizationType.MOBILE_PHONE)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String mainLeaderTel;

	/**
	 * 职业卫生管理人员
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String occManagerName;

	/**
	 * ְ职业卫生管理人员手机号码
	 */
	@Desensitization(type = DesensitizationType.MOBILE_PHONE)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String occManagerTel;


	/**
	 * 营业状态（0-关闭;1-正常;2-暂停营业）
	 */
	private Integer businessState;

	/**
	 * 职业病危害综合风险类别(1-甲类; 2-乙类; 3-丙类)")
	 *
	 */
	private Integer occRiskLevel;

	/**
	 * 职业卫生管理状况等级(1-A; 2-B; 3-C)
	 */
	private Integer occManageLevel;

	/**
	 * 职业病危害风险等级(1-低风险; 2-中风险; 3-高风险)
	 */
	private Integer hazardRiskLevel;



	/**
	 * 本年度最新风险数据
	 */
	private ReformStasticsVo lastReformData;



	/**
	 * 本周期 累计服务检查次数
	 */
	private Integer checkTotalNum;

	/**
	 * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
	 */
	private Integer firstCheckStatus;

	/**
	 * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
	 */
	private Integer secondCheckStatus;

	/**
	 * 最近一次服务检查时间
	 */
	private Date lastCheckDate;

	/**
	 * 接害人数
	 */
	private Integer pickupCount;

	/**
	 * 是否需要服务检查(0-不需要；1-需要)
	 */
	private Integer needCheck;


	/**
	 * 协管中止类型StopTypeEnums(0-无；1-拟暂停；2-拟关闭；3-拟迁移；4-拟恢复)
	 */
	private Integer gjStopType;

	/**
	 * 重写中止类型get方法，因为移动端不需要展示详细的迁移类型，所以将31、32的类型转为3
	 * @author chuhy
	 * @date 2023/6/25 15:42
	 */
	public Integer getGjStopType() {

		if (gjStopType == null){
			return 0;
		} else if (gjStopType == 31 || gjStopType == 32 || gjStopType == 33){
			return 3;
		} else {
			return gjStopType;
		}
	}
}
