
package cn.smarthse.fwgj.model.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import lombok.Data;

import java.io.Serializable;


/**
 * 辖区企业vo
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CompanyInfoVo implements Serializable{
	private static final long serialVersionUID = -1818606404000499101L;

	/**
	 * 公司id
	 */
	private Long id;
	
	/**
	 * 公司名称
	 */
	private String name;

	/**
	 * 营业状态（0-关闭;1-正常;2-暂停营业）
	 */
	private Integer businessState;

	/**
	 * 行政区划id
	 */
	private Long areaId;

	/**
	 * 行政区划名称
	 */
	private String areaName;

	/**
	 * 工作地址
	 */
	private String workAddress;


	/**
	 * 职业卫生负责人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String mainLeaderName;

	/**
	 * 职业卫生负责人联系电话
	 */
	@Desensitization(type = DesensitizationType.MOBILE_PHONE)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String mainLeaderTel;

	/**
	 * 职业卫生管理人员
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String occManagerName;

	/**
	 * ְ职业卫生管理人员手机号码
	 */
	@Desensitization(type = DesensitizationType.MOBILE_PHONE)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String occManagerTel;


	/**
	 * 行业
	 */
	private Integer industryCategory;

	/**
	 * 行业名称
	 */
	private String industryCategoryName;

	/**
	 * 企业规模
	 */
	private Integer scale;

	/**
	 * 企业规模名称
	 */
	private String scaleName;

	/**
	 * 经济类型
	 */
	private Integer registerType;

	/**
	 * 经济类型名称
	 */
	private String registerTypeName;

	/**
	 * 经度
	 */
	private String lng;

	/**
	 * 纬度
	 */
	private String lat;

	/**
	 * 接害人数
	 */
	private Integer pickupCount;


	public String getScaleName() {
		return CompanySizeEnum.getName(scale);
	}
}
