
package cn.smarthse.fwgj.model.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 辖区企业vo
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CompanyDetailVo implements Serializable{
	private static final long serialVersionUID = -1450687965968693357L;

	
	// /**
	//  * 公司名称
	//  */
	// private String name;

	/**
	 * 本年度最新检查id
	 */
	private Long lastCheckId;

	/**
	 * 本年度最新检查名称
	 */
	private String lastCheckName;

	/**
	 * 风险整改本次发现
	 */
	private Integer thisReformNum;

	/**
	 * 本年度最新风险数据
	 */
	private ReformStasticsVo lastReformData;


	/**
	 * 年度检查次数
	 */
	List<CheckNumVo> checkNumData;

	/**
	 * 最新检查人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String checkPeople;

	/**
	 * 最新检查时间
	 */
	private Date checkTime;

	/**
	 * 检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)
	 */
	private Integer checkStatus;

	/**
	 * 服务检查-中止类型(1-企业暂停；2-企业关闭；3-区域变更)
	 */
	private Integer stopType;

	/**
	 * 是否为系统自动创建(0-否；1-是)
	 */
	private Integer isAutoCreate;

	/**
	 * 企业-服务管家中止类型StopTypeEnums(0-无；1-拟暂停；2-拟关闭；3-拟迁移；4-拟恢复)
	 */
	private Integer gjStopType;

	/**
	 * 经度
	 */
	private String lng;

	/**
	 * 纬度
	 */
	private String lat;

	/**
	 * 重写中止类型get方法，因为移动端不需要展示详细的迁移类型，所以将31、32的类型转为3
	 * @author chuhy
	 * @date 2023/6/25 15:42
	 */
	public Integer getGjStopType() {

		if (gjStopType == null){
			return 0;
		} else if (gjStopType == 31 || gjStopType == 32 || gjStopType == 33){
			return 3;
		} else {
			return gjStopType;
		}
	}

	/**
	 * 重写中止类型get方法，因为移动端不需要展示详细的迁移类型，所以将31、32的类型转为3
	 * @author chuhy
	 * @date 2023/6/25 15:42
	 */
	public Integer getStopType() {
		if (stopType != null && (stopType == 31 || stopType == 32 || stopType == 33)){
			return 3;
		} else {
			return stopType;
		}
	}
}
