package cn.smarthse.fwgj.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 巡查记录-巡查项 - 参考数据
 * @author chuhy
 * @since 2023-03-08 11:01
*/
public @Data class CheckItemReferenceDataVo implements Serializable{
	private static final long serialVersionUID = -6341831067621877480L;
	

	/**
	 * 企业id
	 */
    //@ApiModelProperty="企业id")
	private Long cid;
	
	/**
	 * 4.最近一次定期检测日期
	 */
    //@ApiModelProperty="最近一次定期检测日期")
	private Date checkDate;
	
	/**
	 * 4.最近一次评价日期
	 */
    //@ApiModelProperty="最近一次评价日期")
	private Date evalDate;

	/**
	 * 6.最近一次职业健康检查(体检)日期
	 */
	//@ApiModelProperty="最近一次职业健康检查(体检)日期")
	private Date healthDate;

	/**
	 * 11.最近一次设置时间(警示标识与告知)
	 */
	private Date warnSetDate;


	/**
	 * 12.最近一次申报日期
	 */
	//@ApiModelProperty="最近一次申报日期")
	private Date declareDate;

	
	/**
	 *  14.主要负责人培训证书(0-无数据; 1-失效; 2-有效)
	 */
    //@ApiModelProperty="有无主要负责人培训证书(0-无数据;1-失效;2-有效)")
	private Integer trainMainValid;
	
	/**
	 *  14.职业卫生管理人员培训证书(0-无数据; 1-失效; 2-有效)
	 */
    //@ApiModelProperty="职业卫生管理人员培训证书(0-无数据; 1-失效; 2-有效)")
	private Integer trainManageValid;


	/**
	 * 19.最近一次发放时间(个人防护用品)
	 */
	private Date lastDistributeDate;
	
	/**
	 * 20.已开展三同时项目数
	 */
    //@ApiModelProperty="已开展三同时项目数")
	private Integer threeNum;
	

	// **********************************管理档案********************************
	/**
	 * 三同时档案-本年
	 */
    //@ApiModelProperty="三同时档案-本年")
	private String hseFileThree;
	
	/**
	 * 三同时档案-上年
	 */
    //@ApiModelProperty="三同时档案-上年")
	private String hseFileThreeLast;
	
	/**
	 * 职业卫生管理档案-本年
	 */
    //@ApiModelProperty="职业卫生管理档案-本年")
	private String hseFileManage;
	
	/**
	 * 职业卫生管理档案-上年
	 */
    //@ApiModelProperty="职业卫生管理档案-上年")
	private String hseFileManageLast;
	
	/**
	 * 职业卫生宣传培训档案-本年
	 */
    //@ApiModelProperty="职业卫生宣传培训档案-本年")
	private String hseFileTrain;
	
	/**
	 * 职业卫生宣传培训档案-本年
	 */
    //@ApiModelProperty="职业卫生宣传培训档案-本年")
	private String hseFileTrainLast;
	
	/**
	 * 检测与评价档案-本年
	 */
    //@ApiModelProperty="检测与评价档案-本年")
	private String hseFileCheck;
	
	/**
	 * 检测与评价档案-上年
	 */
    //@ApiModelProperty="检测与评价档案-上年")
	private String hseFileCheckLast;
	
	/**
	 * 用人单位职业健康监护管理档案-本年
	 */
    //@ApiModelProperty="用人单位职业健康监护管理档案-本年")
	private String hseFileUnitHealth;
	
	/**
	 * 用人单位职业健康监护管理档案-上年
	 */
    //@ApiModelProperty="用人单位职业健康监护管理档案-上年")
	private String hseFileUnitHealthLast;
	
	/**
	 * 劳动者个人职业健康监护档案-本年
	 */
    //@ApiModelProperty="劳动者个人职业健康监护档案-本年")
	private String hseFileStaffHealth;
	
	/**
	 * 劳动者个人职业健康监护档案-上年
	 */
    //@ApiModelProperty="劳动者个人职业健康监护档案-上年")
	private String hseFileStaffHealthLast;



}
