package cn.smarthse.fwgj.model.param.third;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 机构-未检查预警清单-查询参数
 * @author chuhy
 * @date 2023/7/4
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GjOrgWarningCheckParam extends JqGridParam {
    private static final long serialVersionUID = -94094708075369152L;

    /**
     *  机构id
     */
    private Long orgId;

    private String optName;
    //@ApiModelProperty = "直属企业类（0-非直属，1-省直属，2-市属）",hidden = true)
    private Integer belongType;

    /**
     *  检查表单id
     */
    private Long checkInfoId;

    /**
     * 预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)
     */
    private Integer warningStatus;

    /**
     * 补录状态(0-无需补录；1-可补录；2-不可补录；3-补录中；4-补录完成)
     */
    private Integer supplyStatus;

    /**
     * 申请补录状态(0-无；1-待审核；2-已通过；3-被退回)
     */
    private Integer supplyAuditState;

    /**
     * 原因
     */
    private String reason;

    private Long areaId;
    private Integer areaLevel;
}
