package cn.smarthse.fwgj.model.param.third;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 机构-服务企业列表-查询参数
 * @author chuhy
 * @date 2023/7/4
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GjOrgCompanyQueryParam extends JqGridParam {
    private static final long serialVersionUID = 6247052249612519186L;

    /**
     *  机构id
     */
    private Long orgId;

    /**
     * 当前服务周期情况(1-签约；2-续约)
     */
    private Integer type = 1;

    /**
     * 预警情况(1-含检查预警；2-含检查超期；3-超期与预警)
     */
    private Integer warningSituation;

    /**
     * 当前服务周期情况(1-已服务企业；2-需服务企业)
     */
    private Integer checkSituation;

    /**
     * 状态（1-签约待审核；2-已签约；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回；7-续约申请；8-续约申请被退回）
     */
    private Byte state;
    private Byte renewalCustomerState;

    /**
     * 是否在服务范围内(0-否；1-是)
     */
    private Integer isInRange;

    /**
     * 是否即将到期(0-否；1-是)
     */
    private Integer hasNearDue;

    /**
     *  服务区域
     */
    private Long areaId;

    /**
     *  服务区域 level
     */
    private Byte level;

    /**
     * 是否勾选了左侧的服务范围(0-否；1-是)
     */
    private Integer hasSelectArea = 0;

    /**
     * 是否导出
     */
    private Boolean isExport = false;

}
