package cn.smarthse.fwgj.model.param.check;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 巡查记录-巡查项 - 新增参数
 * @author chuhy
 * @since 2023-03-08 11:01
*/
public @Data class AddCheckItemParam implements Serializable{
	private static final long serialVersionUID = -58431152214673001L;
	
	
	/**
	 * 企业id
	 */
    //@ApiModelProperty="企业id")
	private Long cid;
	
	/**
	 * 巡查id
	 */
    //@ApiModelProperty="巡查id")
	private Long checkId;

	/**
	 * 1.职业病防治年度计划方案（0-否；1-是；2-合理缺项）
	 */
	private Integer check1;

	/**
	 * 2.管理制度及操作规程
	 */
	private Integer check2;

	/**
	 * 3.有害作业和无害作业分开
	 */
	private Integer check3;

	/**
	 * 4.职业病危害因素定期检测
	 */
	private Integer check4;

	/**
	 * 4.最近一次定期检测日期
	 */
	private Date checkDate;

	/**
	 * 4.最近一次评价日期
	 */
	private Date evalDate;

	/**
	 * 5.职业病危害现状评价
	 */
	private Integer check5;

	/**
	 * 6.职业健康体检
	 */
	private Integer check6;

	/**
	 * 6.最近-次体检日期
	 */
	private Date healthDate;

	/**
	 * 7.体检结果书面告知
	 */
	private Integer check7;

	/**
	 * 8.职业禁忌证调岗
	 */
	private Integer check8;

	/**
	 * 9.疑似职业病的报告和诊断
	 */
	private Integer check9;

	/**
	 * 10.职业病防治公告栏
	 */
	private Integer check10;

	/**
	 * 11.职业病危害警示标识与告知卡设置
	 */
	private Integer check11;

	/**
	 * 11.最近一次设置时间
	 */
	private Date warnSetDate;

	/**
	 * 12.职业病危害项目申报
	 */
	private Integer check12;

	/**
	 * 12.最近一次申报日期
	 */
	private Date declareDate;

	/**
	 * 13.职业病危害劳动合同告知
	 */
	private Integer check13;

	/**
	 * 14.主要负责人和职业健康管理员培训
	 */
	private Integer check14;

	/**
	 *      14.主要负责人培训证书(0-无数据; 1-失效; 2-有效)
	 */
	private Integer trainMainValid;

	/**
	 *      14.职业卫生管理人员培训证书(0-无数据; 1-失效; 2-有效)
	 */
	private Integer trainManageValid;

	/**
	 * 15.不得生产、经营、进口、使用国家明令禁止的设备和材料
	 */
	private Integer check15;

	/**
	 * 16.职业病危害作业转移
	 */
	private Integer check16;

	/**
	 * 17.员工职业健康培训
	 */
	private Integer check17;

	/**
	 * 18.防护设施配备和使用情况
	 */
	private Integer check18;

	/**
	 * 19.个人防护用品配置和使用情况
	 */
	private Integer check19;

	/**
	 *       19.最近一次发放时间
	 */
	private Date lastDistributeDate;

	/**
	 * 20.建设项目职业病防护设施三同时
	 */
	private Integer check20;

	/**
	 *        20.已开展三同时项目数
	 */
	private Integer threeNum;

	/**
	 * 21.监管部门限期整改事项
	 */
	private Integer check21;

	/**
	 * 22.建立职业卫生管理档案
	 */
	private Integer check22;

	/**
	 *       22.三同时档案-本年
	 */
	private String hseFileThree;

	/**
	 *       22.三同时档案-上年
	 */
	private String hseFileThreeLast;

	/**
	 *       22.职业卫生管理档案-本年
	 */
	private String hseFileManage;

	/**
	 *       22.职业卫生管理档案-上年
	 */
	private String hseFileManageLast;

	/**
	 *       22.职业卫生宣传培训档案-本年
	 */
	private String hseFileTrain;

	/**
	 *       22.职业卫生宣传培训档案-上年
	 */
	private String hseFileTrainLast;

	/**
	 *       22.检测与评价档案-本年
	 */
	private String hseFileCheck;

	/**
	 *       22.检测与评价档案-上年
	 */
	private String hseFileCheckLast;

	/**
	 *       22.用人单位职业健康监护管理档案-本年
	 */
	private String hseFileUnitHealth;

	/**
	 *       22.用人单位职业健康监护管理档案-上年
	 */
	private String hseFileUnitHealthLast;

	/**
	 *       22.劳动者个人职业健康监护档案-本年
	 */
	private String hseFileStaffHealth;

	/**
	 *       22.劳动者个人职业健康监护档案-上年
	 */
	private String hseFileStaffHealthLast;



}
