package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-辖区企业清单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UnitServcieAreaStatisticsTotalParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -2077664747855707795L;

    @NotNull(message = "区域不能为空")
    //@ApiModelProperty = "区域id",required = true)
    private Long areaId;

    //@ApiModelProperty = "区域等级",required = false)
    private Byte areaLevel;

    //@ApiModelProperty = "是否包含人数小于3的企业（0否 1是）",required = false)
    private Byte ifIncludeLt3Unit;

    @Deprecated
    //@ApiModelProperty = "企业等级（0-非直属，1-省直属，2-市属）",required = false)
    private Integer enterpriseLevel;


    //@ApiModelProperty = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    //@ApiModelProperty = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer includeBelongType;


    //@ApiModelProperty = "等级筛选条件（0全部 1仅显示本级 2仅显示非本级）",required = false)
    private Integer companyLevelType;

    //区域详情相关字段
//    //@ApiModelProperty = "关键词",required = false)
//    private String keyword;
//
//    //@ApiModelProperty = "市本级企业条件（null or 0：全部企业，1：显示市本级企业）")
//    private Byte municipalLevel;
//
//    //@ApiModelProperty = "检查预警条件（null or 0：全部企业，1：存在检查预警）")
//    private Byte alarm;
//
//    //@ApiModelProperty = "合约即将到期企业（null or 0：全部企业，1：合约即将到期企业）")
//    private Byte aboutToExpire;
//
//    //@ApiModelProperty = "即将到期未服务（null or 0:全部，1：已服务企业，2：需服务企业；3服务超期企业）",required = false)
//    private Byte serviceStatus;
}
