package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-辖区企业清单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UnitServcieAreaStatisticsListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -2077664747855707795L;

    @NotNull(message = "区域不能为空")
    //@ApiModelProperty = "区域id",required = true)
    private Long areaId;

    //@ApiModelProperty = "区域等级",required = false)
    private Byte areaLevel;

    //@ApiModelProperty = "是否包含人数小于3的企业（0否 1是）",required = false)
    private Byte ifIncludeLt3Unit;

    @Deprecated
    //@ApiModelProperty = "企业等级（0-非直属，1-省直属，2-市属）",required = false)
    private Byte enterpriseLevel;

    //@ApiModelProperty = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    //@ApiModelProperty = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer includeBelongType;
}
