package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家信息名单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrgGjStatisticsListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message = "区域不能为空")
    //@ApiModelProperty = "区域id",required = true)
    private Long areaId;

    //@ApiModelProperty = "区域等级",required = false)
    private Byte areaLevel;

    //@ApiModelProperty = "年份",required = false)
    private Integer currentYear;

    //@ApiModelProperty = "服务企业数排序（0升序，1降序）",required = false)
    private Integer cmNumSortValue;

    //@ApiModelProperty = "专业职称",required = false)
    private String post;

    //@ApiModelProperty = "文化程度",required = false)
    private String edu;

    //@ApiModelProperty = "就显示市级备案区域(null or 0否 1是)",required = false)
    private Integer onlyCityLevel;

    //@ApiModelProperty = "是否禁用(0-启用；1-禁用)")
    private Integer isForbidden;

    //@ApiModelProperty = "机构是否启用（0否 1是）",required = false)
    private Integer orgIsEnable;

    //@ApiModelProperty = "市级账号的区域",required = false)
    private Long onlyCityAreaId;


}
