package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家禁用启用后待审核列表
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrgGjAuditAgainListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message ="机构id不能为空")
    //@ApiModelProperty = "机构id",required = true)
    private Long oid;

    //@ApiModelProperty = "禁用、启用状态（1-启用待审核；3-启用被退回）",required = false)
    private Integer forbiddenState;

    //@ApiModelProperty = "提交时间起点",required = false)
    private Date sumbitStartTime;

    //@ApiModelProperty = "提交时间结点",required = false)
    private Date sumbitEndTime;

    //@ApiModelProperty = "专业职称",required = false)
    private String post;

    //@ApiModelProperty = "文化程度",required = false)
    private String edu;

}
