package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家信息名单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrgGjAddedInfoAuditListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message ="机构id不能为空")
    //@ApiModelProperty = "机构id",required = true)
    private Long oid;

    //@ApiModelProperty = "管家签约状态（1-待审核；2-已通过；3-被退回；4-终止审核；）",required = false)
    private Integer signingStatus;

    //@ApiModelProperty = "提交时间起点",required = false)
    private Date sumbitStartTime;

    //@ApiModelProperty = "提交时间结点",required = false)
    private Date sumbitEndTime;

    //@ApiModelProperty = "专业职称",required = false)
    private String post;

    //@ApiModelProperty = "文化程度",required = false)
    private String edu;

}
