package cn.smarthse.fwgj.model.param.admin;

import com.alibaba.excel.annotation.ExcelIgnore;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 监管端：管家机构 新增 参数对象
 *
 * @author wuxq
 * @date 2023/6/29 17:02
 */
@Data
public class GjOrgScoreParam implements Serializable {

    private static final long serialVersionUID = -4232719703767566141L;

    /**
     * id
     */
    @NotNull
    private String id;
    /**
     * 机构名称
     */
    @NotNull
    private String orgName;
    /**
     * 统一社会信用
     */
    @NotNull
    private String orgCreditCode;
    /**
     * 评分
     */
    @NotNull
    private String score;

    /**
     * 当前登录监管账号id
     */
    @ExcelIgnore
    private Long loginAdminUserId;
    /**
     * 当前登录监管账号
     */
    @ExcelIgnore
    private String loginAdminUsername;
    /**
     * 当前登录监管账号区域
     */
    @ExcelIgnore
    private Long loginAdminUserAreaId;
    /**
     * 当前登录监管账号等级
     */
    @ExcelIgnore
    private Integer loginAdminUserAreaLevel;


}
