package cn.smarthse.fwgj.model.param.admin;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 监管端：管家机构批量添加企业签约 参数对象
 *
 * @author wuxq
 * @date 2023/6/29 17:02
 */
@Data
public class GjOrgCustomerLotDetailImportParam implements Serializable {

    private static final long serialVersionUID = -4232719703767566141L;

    @NotNull
    private String unitName;

    @NotNull
    private String creditCode;

    @NotNull
    @DateTimeFormat("yyyy/MM/dd")
    private Date signTime;

    @NotNull
    @DateTimeFormat("yyyy/MM/dd")
    private Date expireTime;

    @ExcelIgnore
    private Long createBy;
    @ExcelIgnore
    private Long areaId;
    @ExcelIgnore
    private Integer areaLevel;
    @ExcelIgnore
    private Integer loginAreaLevel;

}
