package cn.smarthse.fwgj.model.param.admin;

import com.alibaba.excel.annotation.ExcelIgnore;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 监管端：管家机构 新增 参数对象
 *
 * @author wuxq
 * @date 2023/6/29 17:02
 */
@Data
public class GjOrgAddParam implements Serializable {


    private static final long serialVersionUID = -4232719703767566141L;

    /**
     * 机构名称
     */
    @NotNull
    private String orgName;
    /**
     * 统一社会信用
     */
    @NotNull
    private String orgCreditCode;
    /**
     * 行政区划
     */
    @NotNull
    private String areaName;
    @ExcelIgnore
    private Long areaId;
    /**
     * 详细地址
     */
    @NotNull
    private String address;
    /**
     * 联系人
     */
    @NotNull
    private String contactName;
    /**
     * 联系方式
     */
    @NotNull
    private String contactPhone;
    /**
     * 法人
     */
    @NotNull
    private String legalPerson;
    /**
     * 法人联系方式
     */
    @NotNull
    private String legalPersonPhone;
    /**
     * 邮箱
     */
    @NotNull
    private String email;

    /**
     * 机构id
     */
    @ExcelIgnore
    private Long orgId;
    /**
     * 机构账号id
     */
    @ExcelIgnore
    private Long orgUserId;

    /**
     * 当前登录监管账号id
     */
    @ExcelIgnore
    private Long loginAdminUserId;
    /**
     * 当前登录监管账号
     */
    @ExcelIgnore
    private String loginAdminUsername;
    /**
     * 当前登录监管账号区域
     */
    @ExcelIgnore
    private Long loginAdminUserAreaId;
    /**
     * 当前登录监管账号等级
     */
    @ExcelIgnore
    private Integer loginAdminUserAreaLevel;


}
