package cn.smarthse.fwgj.model.param;

import jakarta.validation.constraints.NotNull;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 *
 * 风险整改 验收操作 参数对象
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/3/9 16:39
 */
@Data
public class SaveReformRecordParam {

    /**
     * 企业id
     */
    private Long cid;

    @NotNull
    /**
     * 风险id
     */
    private Long reformId;

    @NotNull
    /**
     * 验收负责人
     */
    private String acceptanceDirectorName;

    /**
     * 验收佐证材料 附件ids
     */
    private String acceptanceFiles;

    @NotNull
    /**
     * 验收通过（已完成-3）; 验收不通过（退回-5）ReformStatusEnum
     */
    private Integer status;

    @Length(max = 2000)
    /**
     * 不通过说明
     */
    private String situationDescription;

    /**
     * 登陆用户id
     */
//@ApiModelProperty(hidden = true)
    private Long userId;

    /**
     * 用户姓名
     */
//@ApiModelProperty(hidden = true)
    private String fullName;
}
