package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 服务管家机构人员账号关系
 * 管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核）
 *
 * @author wuxq
 * @date 2023/6/30 16:10
 */
@AllArgsConstructor
@Getter
public enum ThirdGjUserLogStateEnums {

    /**
     * 0-草稿
     */
    DRAFT(0, "草稿"),
    /**
     * 1-待审核
     */
    PENDING_AUDIT(1, "待审核"),
    /**
     * 2-已通过
     */
    PASS(2, "已通过"),
    /**
     * 3-被退回
     */
    REFUED(3, "被退回"),
    /**
     * 4-终止审核
     */
    STOP(4, "终止审核"),
    ;

    private final Integer value;

    private final String name;

}
