package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 *  管家账号log 禁用启用状态（0-禁用；1-启用待审核；2-启用；3-启用被退回）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum ThirdGjUserLogForbiddenStateEnum {

    /**
     * 0-禁用
     */
    Forbidden(0, "禁用"),
    /**
     * 1-启用待审核
     */
    PENDING_AUDIT(1, "启用待审核"),
    /**
     * 2-启用
     */
    PASS(2, "启用"),
    /**
     * 3-启用被退回
     */
    REFUED(3, "启用被退回"),
    ;

    private final Integer value;

    private final String name;

}
