package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 机构签约 合同类型（1-签约；2-续约）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/10/7 10:52
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgCustomerTypeEnum {

    /**
     * 1-签约
     */
    type1(1, "签约"),
    /**
     * 2-续约
     */
    type2(2, "续约"),

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {

        ThirdGjOrgCustomerTypeEnum[] enums = values();

        for (ThirdGjOrgCustomerTypeEnum record : enums) {
            if (record.value.equals(value)) {
                return record.name;
            }
        }
        return null;
    }

}
