package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 服务管家 审核操作类型
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/3 16:13
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgAuditOptEnum {

    //1-管家机构 备案 审核记录
    /** 11-发起签约*/
    org_opt_1(11, "发起签约"),
    /** 12-签约成功*/
    org_opt_2(12, "签约成功"),
    /** 13-退回签约*/
    org_opt_3(13, "退回签约"),
    /** 14-禁用备案*/
    org_opt_4(14, "禁用"),

    //2-管家机构 签约 企业审核记录
    /** 21-发起签约*/
    customer_sign_opt_1(21, "发起签约"),
    /** 22-签约成功*/
    customer_sign_opt_2(22, "签约成功"),
    /** 23-退回签约*/
    customer_sign_opt_3(23, "退回签约"),

    //3-管家机构 解约 企业审核记录
    /** 31-发起解约*/
    customer_cancel_opt_1(31, "发起解约"),
    /** 32-解约成功*/
    customer_cancel_opt_2(32, "解约成功"),
    /** 33-退回解约*/
    customer_cancel_opt_3(33, "退回解约"),

    //4-管家账号审核记录 forbidden_state 禁用、启用状态（0-禁用；1-启用待审核；2-启用；3-启用被退回）
    /** 41-管家账号启用发起审核  */
    user_log_opt_1(41, "管家账号启用发起审核"),
    /** 42-管家账号启用审核通过*/
    user_log_opt_2(42, "管家账号启用审核通过"),
    /** 43-管家账号启用退回*/
    user_log_opt_3(43, "管家账号启用退回"),
    /** 44-管家账号禁用*/
    user_log_opt_4(44, "管家账号禁用"),

    //4-管家账号审核记录 state 管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核）
    /** 401-发起审核*/
    user_log_state_1(401, "发起审核"),
    /** 402-通过审核*/
    user_log_state_2(402, "通过审核"),
    /** 403-退回审核*/
    user_log_state_3(403, "退回审核"),
    /** 404-终止审核*/
    user_log_state_4(404, "终止审核"),
    //4-管家账号审核记录 state 管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核）
    /** 61-管家服务记录审核认定操作*/
    check_info_opt_1(61, "监管认定"),

    /** 701-管家服务-补录审核操作*/
    check_info_supply_opt_1(701, "发起审核"),
    check_info_supply_opt_2(702, "通过审核"),
    check_info_supply_opt_3(703, "退回审核"),
    ;

    private final Integer optValue;
    private final String optName;

}
