package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 服务认定类型
 *
 * @author chenliang
 */
@AllArgsConstructor
@Getter
public enum IdentificationTypeEnums {


    ADMIN(1, "监管认定"),
    ;

    private final Integer code;

    private final String name;

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (IdentificationTypeEnums c : IdentificationTypeEnums.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }

}
