package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 签约企业，预警状态(0-无预警；1-含检查预警；2-含检查超期；3-超期与预警)
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCustomerWarningStatusEnum {


    /**
     * 0-无预警
     */
    NO_WARNING(0, "无预警"),
    /**
     * 1-含检查预警
     */
    WARNING(1, "含检查预警"),
    /**
     * 2-含检查超期
     */
    OVERDUE(2, "含检查超期"),
    /**
     * 3-超期与预警
     */
    OVERDUE_WARNING(3, "超期与预警")

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCustomerWarningStatusEnum[] cycleEnums = values();
        for (GjCustomerWarningStatusEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }


}
