package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 检查记录 - 申请补录状态（1-待审核；2-已通过；3-被退回；）
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCheckInfoSupplyAuditStateEnum {


    /**
     * 0 - 无
     */
    NONE(0, "无"),
    /**
     * 1-待审核
     */
    UNAUDITED(1, "待审核"),
    /**
     * 2-已通过
     */
    PASSED(2, "已通过"),
    /**
     * 3-被退回
     */
    RETURNED(3, "被退回"),

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCheckInfoSupplyAuditStateEnum[] cycleEnums = values();
        for (GjCheckInfoSupplyAuditStateEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }


}
