package cn.smarthse.fwgj.entity.thirdGj;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 管家服务-机构、企业签约
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
@TableName("third_gj_org_customer")
public class ThirdGjOrgCustomer implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *  id
     */
    @TableId(value = "id")
    private Long id;
    /**
     * 管家机构id
     */
    private Long gjOrgId;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构账号id
     */
    private Long userId;
    /**
     * 签约单位id
     */
    private Long cid;
    /**
     * 机构联系人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String orgMan;
    /**
     * 机构联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String orgTel;
    /**
     * 签约企业名称
     */
    private String unitName;
    /**
     * 签约企业统一社会信用代码
     */
    private String unitCreditCode;
    /**
     * 企业联系人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String unitMan;
    /**
     * 企业联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String unitTel;
    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）来源数据中心
     */
    private Byte belongType;
    /**
     * 企业区域id
     */
    private Long areaId;
    /**
     * 省id
     */
    private Long areaId1;
    /**
     * 市id
     */
    private Long areaId2;
    /**
     * 区id
     */
    private Long areaId3;
    /**
     * 街道id
     */
    private Long areaId4;
    /**
     * 企业地址
     */
    private String unitAddress;
    /**
     * 合同类型（1-签约；2-续约）
     */
    private Integer type;
    /**
     * 来源（1-监管创建；2-机构创建）
     */
    private Integer source;
    /**
     * 合约开始时间
     */
    private Date signTime;
    /**
     * 合约结束时间
     */
    private Date expireTime;
    /**
     * 签约时间
     */
    private Date concludeTime;
    /**
     * 解约时间
     */
    private Date cancelTime;
    /**
     * 解约理由
     */
    private String cancelReason;
    /**
     * 状态（1：签约待审核；2：已签约；3：签约被退回；3：解约待审核；4：已解约；解约被退回）
     */
    private Integer state;
    /**
     * 是否为需要展示的数据(0-否；1-是) 签约时根据cid、orgId，把以前的变为0
     */
    private Integer isShowData;
    /**
     * 未签约状态类型(0-无；1-发起解约后变更；2-到期后变更)
     * tips：用于区分是到期后变成的未签约还是退回变成的未签约
     */
    private Integer unsignType;

    /**
     * 是否在机构服务范围内(0-不在；1-在)
     */
    private Integer isInRange;
    /**
     * 合同附件id（多个用,隔开）
     */
    private String contractFileId;


    /**
     * 当前合同周期(第几合约年)
     */
    private Integer curContractYear;
    /**
     * 当前的上\下半周期(1-上半周期；2-下半周期)
     */
    private Integer curCycle;
    /**
     * 上半周期检查次数
     */
    private Integer firstCheckNum;
    /**
     * 下半周期检查次数
     */
    private Integer secondCheckNum;
    /**
     * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer firstCheckStatus;
    /**
     * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer secondCheckStatus;


    /**
     * 签约企业-预警状态(0-无预警；1-含检查预警；2-含检查超期；3-超期与预警)
     */
    private Integer warningStatus;
    /**
     * 当前半周期是否需要检查(0-不需要；1-需要；2-已服务检查)
     * 注：服务状态处于’进行中‘ 或 有超期检查时，状态为需要
     */
    private Integer needCheck;

    /**
     * 废弃 - 是否需要补录(0-不需要；1-需要；2-不可补录)
     */
    @Deprecated
    private Integer needSupply;

    //@ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    //@ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    //@ApiModelProperty = "是否有效（1-有效；0-无效）")
    private Integer isValid;
}
