package cn.smarthse.fwgj.entity.thirdGj;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 服务管家机构
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/6/20 13:34
 */
@TableName("third_gj_org")
@Data
public class ThirdGjOrg implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *  id
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构账号id
     */
    private Long userId;
    /**
     * 机构名
     */
    private String orgName;
    /**
     * 机构地址
     */
    private String address;
    /**
     * 机构社会统一信用代码
     */
    private String orgCreditCode;
    /**
     * 备案名称（eg：杭州市上城区）
     */
    private String baName;
    /**
     * 行政区划id（服务范围）
     */
    private Long areaId;
    /**
     * 行政区划level（服务范围）
     */
    private Integer level;
    /**
     * 省id
     */
    private Long areaId1;
    /**
     * 市id
     */
    private Long areaId2;
    /**
     * 区id
     */
    private Long areaId3;
    /**
     * 评分/星
     */
    private Integer score;
    /**
     * 状态（0：草稿；1：待审核；2：已通过；3：被退回）
     */
    private Integer state;
    /**
     * 提交时间
     */
    private Date subTime;
    /**
     * 审核通过时间
     */
    private Date auditTime;
    /**
     * 签约时间
     */
    private Date signTime;
    /**
     * 到期时间
     */
    private Date expireTime;
    /**
     * 申请书附件id（多个用,隔开）
     */
    private String applyFile;
    /**
     * 承诺书附件id（多个用,隔开）
     */
    private String commitmentFile;
    /**
     * 营业执照附件id（多个用,隔开）
     */
    private String busLicenseFile;

    //@ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    //@ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    //@ApiModelProperty = "是否有效（1-有效；0-无效）")
    private Integer isValid;
}
