package cn.smarthse.fwgj.entity.thirdGj;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 服务检查-检查项
 *
 * @author chuhy
 * @since 2023-06-27 03:16
 */
@Data
@TableName("third_gj_check_info")
public class ThirdGjCheckInfo implements Serializable {

    private static final long serialVersionUID = -8865844638860320765L;

    @TableId(value = "id")
    private Long id;

    /**
     * 管家人员账号id
     */
    private Long gjUserId;

    /**
     * 机构id
     */
    private Long orgId;

    /**
     * 机构账号id
     */
    private Long orgUserId;

    /**
     * 单位id
     */
    private Long cid;

    /**
     * 单位签约id
     */
    private Long customerId;

    /**
     * 单位名称
     */
    private String unitName;

    /**
     * 单位营业状态
     */
    private Integer unitStatus;

    /**
     * 主要负责人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String manager;

    /**
     * 联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String tel;

    /**
     * 职业健康管理人员
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String hseManager;

    /**
     * 职业健康管理人员-联系电话
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String hesTel;

    /**
     * 行政区划地址
     */
    private String address;

    /**
     * 工作场所地址
     */
    private String workAddress;

    /**
     * 行政区划
     */
    private Long areaId;

    /**
     * 省id
     */
    private Long areaId1;

    /**
     * 市id
     */
    private Long areaId2;

    /**
     * 区id
     */
    private Long areaId3;

    /**
     * 区街道d
     */
    private Long areaId4;

    /**
     * 行业编码
     */
    private String industryCode;

    /**
     * 行业名
     */
    private String industryName;

    /**
     * 规模
     */
    private String scaleCode;

    /**
     * 经济
     */
    private String economyCode;

    /**
     * 经济名称
     */
    private String economyName;

    /**
     * 服务名称
     */
    private String checkName;

    /**
     * 检查完成时,合同所属周期(第几个合约年)
     */
    private Integer curContractYear;

    /**
     * 检查完成时,所处半周期(1-上半周期；2-下半周期)
     */
    private Integer curCycle;

    /**
     * 服务人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String checkPeople;

    /**
     * 服务检查时间
     */
    private Date checkTime;

    /**
     * 服务痕迹附件
     */
    private String checkFile;

    /**
     * 企业负责人签字
     */
    private Long unitManageSign;

    /**
     * 服务状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止)
     */
    private Integer checkStatus;

    /**
     * 服务完成类型(0-无；1-巡查打卡；2-监管认定)
     */
    private Integer doneType;

    /**
     * 服务中止类型(0-无；1-企业暂停；2-企业关闭；31-区域变更(跨地市迁移)； 32-区域变更(地市内迁移)；4-企业恢复(正常营业))
     */
    private Integer stopType;

    /**
     * 预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)
     */
    private Integer warningStatus;

    /**
     * 补录状态(0-无需补录；1-可补录；2-不可补录；3-补录完成)
     */
    private Integer supplyStatus;

    /**
     * 申请补录状态（1-待审核；2-已通过；3-被退回；）
     */
    private Integer supplyAuditState;

    /**
     * 是否为系统自动创建(0-否；1-是)
     */
    private Integer isAutoCreate;


    /**
     * 自动创建时，初始化的合约年
     */
    private Integer createContractYear;

    /**
     * 自动创建时，初始化的半周期(1-上半周期；2-下半周期)
     */
    private Integer createCycle;

    /**
     * 自动创建时，初始化冗余的签约时间
     */
    private Date createSignTime;
    /**
     * 认定类型（1监管认定）
     */
    private Integer identificationType;

    //@ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    //@ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    //@ApiModelProperty = "是否有效（1-有效；0-无效）")
    private Integer isValid;

    /**
     * 来源(appId)
     */
    //@ApiModelProperty="来源(appId)", hidden = true)
    private String source;
    /**
     * 来源数据id
     */
    //@ApiModelProperty("来源数据id")
    private String sourceId;

}
