package cn.smarthse.fwgj.entity.sys;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * 机构：机构管家人员账号
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@TableName("third_gj_user_log")
@Data
public class ThirdGjUserLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId(value = "ID")
    private Long id;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构账号id
     */
    private Long userId;
    /**
     * 管家账号id
     */
    private Long gjUserId;
    /**
     * 管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核）ThirdGjUserLogStateEnums
     */
    private Integer state;
    /**
     * 禁用启用状态（0-禁用；1-启用待审核；2-启用；3-启用被退回）ThirdGjUserLogForbiddenStateEnum
     */
    private Integer forbiddenState;
    /**
     * 禁用、启用时间
     */
    private Date forbiddenDate;
    /**
     * 启用被退回原因（最新）
     */
    private String forbiddenReason;
    /**
     * 提交时间（最近一次）
     */
    private Date subTime;
    /**
     * 账号审核被退回原因（最新）
     */
    private String reason;

    //@ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    //@ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    //@ApiModelProperty = "是否有效（1-有效；0-无效）")
    private Integer isValid;

}
