package cn.smarthse.fwgj.entity.sys;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 《系统用户表》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-5-27-上午10:38:06
 */
@TableName("sys_user")
@Data
public class SysUser implements Serializable {

    private static final long serialVersionUID = 5922477750792334910L;

    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 所属机构编号
     */
    private Long cid;

    /**
     * 用户名
     */
    private String username;

    /**
     * 登录加密密码（SHA-1）
     */
    private String password;

    /**
     * 登录盐值
     */
    private String salt;

    /**
     * 头像文件编号（file.id)
     */
    private Long faceId;

    /**
     * 用户姓名
     */
    private String fullname;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 是否管理员
     */
    private Boolean isManger;

    /**
     * 是否禁用
     */
    private Boolean isForbidden;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;
    /**
     * 禁用时间
     */
    private Date forbiddenTime;
    /**
     * 取消禁用（启用）时间
     */
    private Date cancelForbiddenTime;
    /**
     * 手机号码
     */
    private String mobile;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 用户角色（0——普通角色  1——第三方托管服务人员）
     */
    private Integer roleCode;

    /**
     * 是否是默认密码
     */
    private Boolean isDefaultPwd;

    /**
     * 密码修改时间
     */
    private Date pwdUpdateTime;

    /**
     * 来源（1：默认；3：注册）
     */
    private Integer resource;

}