/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.encrypt.spring.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.spring.service.EsEncryptService;
import cn.smarthse.encrypt.utils.EncryptUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringEncryptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringEncryptUtils.class);
    private static volatile EsEncryptService esEncryptService;

    public static FieldEncryptorProperties getFieldEncryptorProperties() {
        return FieldEncryptorPropertiesHolder.INSTANCE;
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return ScheduledExecutorServiceHolder.INSTANCE;
    }

    public static String encrypt(String data) {
        FieldEncryptorProperties properties = SpringEncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnabled(), Boolean.TRUE)) {
            return data;
        }
        if (StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        if (StrUtil.startWith((CharSequence)(data = StrUtil.trim((CharSequence)data)), (CharSequence)"VI*D#S")) {
            log.warn("[Encrypt] [\u52a0\u5bc6] [failure] [warn] [unknown] reason=duplicate_encryption originalData={}", (Object)data);
            return data;
        }
        Object ciphertext = null;
        boolean middlewareEnabled = Objects.equals(properties.getMiddlewareEnabled(), Boolean.TRUE);
        String dataSm4 = null;
        FieldEncryptorProperties.GroupConfig maxVersionGroupConfig = properties.getMaxVersionGroupConfig();
        if (middlewareEnabled) {
            try {
                dataSm4 = EncryptUtils.encryptBySm4((String)data, (String)maxVersionGroupConfig.getPassword());
                if (StrUtil.isNotBlank((CharSequence)dataSm4)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u51c6\u5907] [success] [debug] [unknown] originalData={} sm4Result={}", (Object)data, (Object)dataSm4);
                    }
                    ciphertext = SpringEncryptUtils.getEsEncryptService().getCiphertext(dataSm4);
                    if (log.isDebugEnabled()) {
                        log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u5904\u7406] [success] [debug] [unknown] originalData={} middlewareResult={}", (Object)data, ciphertext);
                    }
                }
            }
            catch (Exception e) {
                log.warn("[Encrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] originalData={} errorMsg={} exceptionClass={}", new Object[]{data, e.getMessage(), e.getClass().getSimpleName(), e});
            }
        }
        if (StrUtil.isNotBlank(ciphertext)) {
            return ciphertext;
        }
        if (Objects.equals(properties.getAlgorithm(), "SM4")) {
            ciphertext = maxVersionGroupConfig.getVersion() + EncryptUtils.encryptBySm4((String)data, (String)maxVersionGroupConfig.getPassword());
        } else if (Objects.equals(properties.getAlgorithm(), "WCSP_LIGHT_DATA_SERVICE")) {
            byte[] byteData = data.getBytes(StandardCharsets.UTF_8);
            if (byteData.length > 1023) {
                throw new IllegalArgumentException("Input data is too long");
            }
            ciphertext = EncryptUtils.getWcspVersion() + EncryptUtils.encryptByWcspLightDataService((String)data);
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
        }
        if (log.isDebugEnabled()) {
            log.debug("[Encrypt] [\u672c\u5730\u5904\u7406] [success] [debug] [unknown] originalData={} encryptedResult={}", (Object)data, ciphertext);
        }
        if (StrUtil.isBlank((CharSequence)ciphertext)) {
            return data;
        }
        if (middlewareEnabled && StrUtil.isNotBlank((CharSequence)dataSm4)) {
            Object finalCiphertext = ciphertext;
            String finalDataSm4 = dataSm4;
            CompletableFuture.runAsync(() -> SpringEncryptUtils.lambda$encrypt$0(finalDataSm4, (String)finalCiphertext), SpringEncryptUtils.getScheduledExecutorService());
        }
        return ciphertext;
    }

    public static String decrypt(String data) {
        FieldEncryptorProperties properties = SpringEncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnabled(), Boolean.TRUE)) {
            return data;
        }
        if (StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        if (data.length() <= 14 || !StrUtil.startWith((CharSequence)data, (CharSequence)"VI*D#S")) {
            return data;
        }
        String plaintext = null;
        boolean middlewareEnabled = Objects.equals(properties.getMiddlewareEnabled(), Boolean.TRUE);
        String password = properties.getMaxVersionGroupConfig().getPassword();
        if (middlewareEnabled) {
            try {
                String dataSm4 = SpringEncryptUtils.getEsEncryptService().getPlaintext(data);
                if (StrUtil.isNotBlank((CharSequence)dataSm4)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u51c6\u5907] [success] [debug] [unknown] encryptedData={} sm4Ciphertext={}", (Object)data, (Object)dataSm4);
                    }
                    plaintext = EncryptUtils.decryptBySm4((String)dataSm4, (String)password);
                    if (log.isDebugEnabled()) {
                        log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u5904\u7406] [success] [debug] [unknown] encryptedData={} decryptedResult={}", (Object)data, (Object)plaintext);
                    }
                }
            }
            catch (Exception e) {
                log.warn("[Decrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] encryptedData={} errorMsg={} exceptionClass={}", new Object[]{data, e.getMessage(), e.getClass().getSimpleName(), e});
            }
        }
        if (StrUtil.isNotBlank(plaintext)) {
            return plaintext;
        }
        if (Objects.equals(properties.getAlgorithm(), "SM4")) {
            FieldEncryptorProperties.GroupConfig versionGroupConfig = properties.getMaxVersionGroupConfig();
            plaintext = EncryptUtils.decryptBySm4((String)StrUtil.subSuf((CharSequence)data, (int)14), (String)versionGroupConfig.getPassword());
        } else if (Objects.equals(properties.getAlgorithm(), "WCSP_LIGHT_DATA_SERVICE")) {
            plaintext = EncryptUtils.decryptByWcspLightDataService((String)StrUtil.subSuf((CharSequence)data, (int)14));
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
        }
        if (log.isDebugEnabled()) {
            log.debug("[Decrypt] [\u672c\u5730\u5904\u7406] [success] [debug] [unknown] encryptedData={} decryptedResult={}", (Object)data, (Object)plaintext);
        }
        if (StrUtil.isBlank((CharSequence)plaintext)) {
            return data;
        }
        if (middlewareEnabled) {
            String finalPlaintext = plaintext;
            CompletableFuture.runAsync(() -> {
                try {
                    SpringEncryptUtils.getEsEncryptService().addCiphertext(EncryptUtils.encryptBySm4((String)finalPlaintext, (String)password), data);
                    if (log.isDebugEnabled()) {
                        log.debug("[Decrypt] [\u4e2d\u95f4\u4ef6\u540c\u6b65] [success] [debug] [unknown] plaintext={} middlewareCiphertext={}", (Object)finalPlaintext, (Object)data);
                    }
                }
                catch (Exception e) {
                    log.warn("[Decrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] plaintext={} ciphertext={} errorMsg={} exceptionClass={}", new Object[]{finalPlaintext, data, e.getMessage(), e.getClass().getSimpleName(), e});
                }
            }, SpringEncryptUtils.getScheduledExecutorService());
        }
        return plaintext;
    }

    @Generated
    private SpringEncryptUtils() {
    }

    @Generated
    public static void setEsEncryptService(EsEncryptService esEncryptService) {
        SpringEncryptUtils.esEncryptService = esEncryptService;
    }

    @Generated
    public static EsEncryptService getEsEncryptService() {
        return esEncryptService;
    }

    private static /* synthetic */ void lambda$encrypt$0(String finalDataSm4, String finalCiphertext) {
        try {
            SpringEncryptUtils.getEsEncryptService().addCiphertext(finalDataSm4, finalCiphertext);
            if (log.isDebugEnabled()) {
                log.debug("[Encrypt] [\u4e2d\u95f4\u4ef6\u540c\u6b65] [success] [debug] [unknown] sm4Value={} middlewareCiphertext={}", (Object)finalDataSm4, (Object)finalCiphertext);
            }
        }
        catch (Exception e) {
            log.warn("[Encrypt] [\u4e2d\u95f4\u4ef6\u5f02\u5e38] [failure] [warn] [unknown] sm4Value={} ciphertext={} errorMsg={} exceptionClass={}", new Object[]{finalDataSm4, finalCiphertext, e.getMessage(), e.getClass().getSimpleName(), e});
        }
    }

    private static class FieldEncryptorPropertiesHolder {
        private static final FieldEncryptorProperties INSTANCE = (FieldEncryptorProperties)SpringUtil.getBean(FieldEncryptorProperties.class);

        private FieldEncryptorPropertiesHolder() {
        }
    }

    private static class ScheduledExecutorServiceHolder {
        private static final ScheduledExecutorService INSTANCE = (ScheduledExecutorService)SpringUtil.getBean((String)"scheduledExecutorService", ScheduledExecutorService.class);

        private ScheduledExecutorServiceHolder() {
        }
    }
}

