/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.encrypt.spring.service;

import cn.smarthse.encrypt.spring.properties.RocksDBConfig;
import cn.smarthse.encrypt.spring.service.EsEncryptService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBEncryptService
implements EsEncryptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBEncryptService.class);
    private final RocksDBConfig rocksDBConfig;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final String PLAINTEXT_PREFIX = "plaintext:";
    private static final String CIPHERTEXT_PREFIX = "ciphertext:";

    @Override
    public void selfInspection() {
        try {
            String testKey = "test_key";
            String testValue = "test_value";
            this.addCiphertext(testKey, testValue);
            String result = this.getCiphertext(testKey);
            log.info("[RocksDB] [\u81ea\u68c0] [success] [info] [unknown] testResult={}", (Object)result);
        }
        catch (Exception e) {
            log.error("[RocksDB] [\u81ea\u68c0] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
            throw new RuntimeException("RocksDB\u670d\u52a1\u81ea\u68c0\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCiphertext(String plaintext, String ciphertext) {
        if (plaintext == null || ciphertext == null) {
            return;
        }
        try {
            this.readWriteLock.writeLock().lock();
            String plaintextKey = PLAINTEXT_PREFIX + plaintext;
            this.rocksDBConfig.getRocksDB().put(RocksDBConfig.stringToBytes(plaintextKey), RocksDBConfig.stringToBytes(ciphertext));
            String ciphertextKey = CIPHERTEXT_PREFIX + ciphertext;
            this.rocksDBConfig.getRocksDB().put(RocksDBConfig.stringToBytes(ciphertextKey), RocksDBConfig.stringToBytes(plaintext));
            if (log.isDebugEnabled()) {
                log.debug("[RocksDB] [\u6dfb\u52a0\u5bc6\u6587] [success] [debug] [unknown] plaintext={} ciphertext={}", (Object)plaintext, (Object)ciphertext);
            }
        }
        catch (RocksDBException e) {
            log.error("[RocksDB] [\u6dfb\u52a0\u5bc6\u6587] [failure] [error] [unknown] plaintext={} ciphertext={} errorMsg={} exceptionClass={}", new Object[]{plaintext, ciphertext, e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), e});
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCiphertext(String plaintext) {
        if (plaintext == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            String plaintextKey = PLAINTEXT_PREFIX + plaintext;
            byte[] valueBytes = this.rocksDBConfig.getRocksDB().get(RocksDBConfig.stringToBytes(plaintextKey));
            String result = RocksDBConfig.bytesToString(valueBytes);
            if (log.isDebugEnabled()) {
                log.debug("[RocksDB] [\u83b7\u53d6\u5bc6\u6587] [success] [debug] [unknown] plaintext={} ciphertext={}", (Object)plaintext, (Object)result);
            }
            String string = result;
            return string;
        }
        catch (RocksDBException e) {
            log.error("[RocksDB] [\u83b7\u53d6\u5bc6\u6587] [failure] [error] [unknown] plaintext={} errorMsg={} exceptionClass={}", new Object[]{plaintext, e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), e});
            String string = null;
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlaintext(String ciphertext) {
        if (ciphertext == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            String ciphertextKey = CIPHERTEXT_PREFIX + ciphertext;
            byte[] valueBytes = this.rocksDBConfig.getRocksDB().get(RocksDBConfig.stringToBytes(ciphertextKey));
            String result = RocksDBConfig.bytesToString(valueBytes);
            if (log.isDebugEnabled()) {
                log.debug("[RocksDB] [\u83b7\u53d6\u660e\u6587] [success] [debug] [unknown] ciphertext={} plaintext={}", (Object)ciphertext, (Object)result);
            }
            String string = result;
            return string;
        }
        catch (RocksDBException e) {
            log.error("[RocksDB] [\u83b7\u53d6\u660e\u6587] [failure] [error] [unknown] ciphertext={} errorMsg={} exceptionClass={}", new Object[]{ciphertext, e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), e});
            String string = null;
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Generated
    public RocksDBEncryptService(RocksDBConfig rocksDBConfig) {
        this.rocksDBConfig = rocksDBConfig;
    }
}

