/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.encrypt.spring.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringEncryptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringEncryptUtils.class);

    public static FieldEncryptorProperties getFieldEncryptorProperties() {
        return FieldEncryptorPropertiesHolder.INSTANCE;
    }

    public static String encrypt(String value) {
        FieldEncryptorProperties properties = SpringEncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnabled(), true)) {
            return value;
        }
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6\uff01\uff01\uff01");
            return value;
        }
        if (Objects.equals(properties.getAlgorithm(), "SM4")) {
            FieldEncryptorProperties.GroupConfig maxVersionGroupConfig = properties.getMaxVersionGroupConfig();
            return maxVersionGroupConfig.getVersion() + EncryptUtils.encryptBySm4((String)value, (String)maxVersionGroupConfig.getPassword());
        }
        if (Objects.equals(properties.getAlgorithm(), "WCSP_LIGHT_DATA_SERVICE")) {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            if (data.length > 1023) {
                throw new IllegalArgumentException("Input data is too long");
            }
            return EncryptUtils.getWcspVersion() + EncryptUtils.encryptByWcspLightDataService((String)value);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
    }

    public static String decrypt(String value) {
        FieldEncryptorProperties properties = SpringEncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnabled(), true)) {
            return value;
        }
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
            return value;
        }
        if (Objects.equals(properties.getAlgorithm(), "SM4")) {
            String version = StrUtil.subPre((CharSequence)value, (int)14);
            String finalValue = value;
            FieldEncryptorProperties.GroupConfig versionGroupConfig = properties.getGroupConfigs().stream().filter(groupConfig -> StrUtil.equals((CharSequence)groupConfig.getVersion(), (CharSequence)version)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u89e3\u5bc6\u672a\u627e\u5230\u5bf9\u5e94\u7248\u672c\uff1a" + version + "\uff0c\u539f\u59cb\u503c\uff1a" + finalValue));
            value = StrUtil.subSuf((CharSequence)value, (int)14);
            return EncryptUtils.decryptBySm4((String)value, (String)versionGroupConfig.getPassword());
        }
        if (Objects.equals(properties.getAlgorithm(), "WCSP_LIGHT_DATA_SERVICE")) {
            value = StrUtil.subSuf((CharSequence)value, (int)14);
            return EncryptUtils.decryptByWcspLightDataService((String)value);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
    }

    private static class FieldEncryptorPropertiesHolder {
        private static final FieldEncryptorProperties INSTANCE = (FieldEncryptorProperties)SpringUtil.getBean(FieldEncryptorProperties.class);

        private FieldEncryptorPropertiesHolder() {
        }
    }
}

