/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.encrypt.utils;

import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.typicalservice.LightDataService;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.smarthse.encrypt.context.WcspEncryptContext;
import cn.smarthse.encrypt.pool.WcspCryptoServicePlatformPool;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcspEncryptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspEncryptUtils.class);
    private static WcspCryptoServicePlatformPool wcspCryptoServicePlatformPool;
    private static WcspEncryptContext context;
    private static final ThreadLocal<LightDataService> lightDataServiceThreadLocal;

    public static void initialize(WcspCryptoServicePlatformPool pool) {
        wcspCryptoServicePlatformPool = pool;
        context = pool.getContext();
        log.info("WcspEncryptUtils\u8d44\u6e90\u5df2\u521d\u59cb\u5316");
    }

    public static void close() {
        if (Objects.nonNull(wcspCryptoServicePlatformPool)) {
            wcspCryptoServicePlatformPool.close();
        }
        log.info("WcspEncryptUtils\u8d44\u6e90\u5df2\u91ca\u653e");
    }

    public static String getWcspVersion() {
        return context.getVersion();
    }

    public static String getKeyId() {
        return context.getKeyId();
    }

    private static LightDataService getLightDataService(WcspCryptoServicePlatformPool pool, String keyId) throws Exception {
        LightDataService service = lightDataServiceThreadLocal.get();
        if (Objects.isNull(service)) {
            CryptoServicePlatform platform = pool.borrowObject();
            service = LightDataService.getInstance((CryptoServicePlatform)platform, (String)keyId);
            lightDataServiceThreadLocal.set(service);
        }
        return service;
    }

    public static String executeEncryptionByWcspLightDataServiceCommon(String data, Function<byte[], String> resultEncoder) {
        log.debug("\u52a0\u5bc6\u524d\u6570\u636e:{}", (Object)data);
        LightDataService service = null;
        boolean isHealthy = true;
        try {
            service = WcspEncryptUtils.getLightDataService(wcspCryptoServicePlatformPool, WcspEncryptUtils.getKeyId());
            byte[] encrypted = service.encrypt(ConversionUtils.Data.fromUTF8String((String)data));
            String string = resultEncoder.apply(encrypted);
            return string;
        }
        catch (Exception e) {
            isHealthy = false;
            log.error("\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("executeEncryptionByWcspLightDataServiceCommon", e);
        }
        finally {
            WcspEncryptUtils.cleanupService(service, isHealthy);
        }
    }

    public static String executeDecryptionByWcspLightDataServiceCommon(String data, Function<String, byte[]> paramEncoder) {
        log.debug("\u89e3\u5bc6\u524d\u6570\u636e:{}", (Object)data);
        LightDataService service = null;
        boolean isHealthy = true;
        try {
            service = WcspEncryptUtils.getLightDataService(wcspCryptoServicePlatformPool, WcspEncryptUtils.getKeyId());
            byte[] decrypted = service.decrypt(paramEncoder.apply(data));
            String string = ConversionUtils.Data.toUTF8String((byte[])decrypted);
            return string;
        }
        catch (Exception e) {
            isHealthy = false;
            log.error("\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("executeDecryptionByWcspLightDataServiceCommon", e);
        }
        finally {
            WcspEncryptUtils.cleanupService(service, isHealthy);
        }
    }

    private static void cleanupService(LightDataService service, boolean isHealthy) {
        if (Objects.nonNull(service)) {
            lightDataServiceThreadLocal.remove();
            wcspCryptoServicePlatformPool.returnObject(service.platform(), isHealthy);
        }
    }

    public static String encryptByWcspLightDataService(String data) {
        return WcspEncryptUtils.executeEncryptionByWcspLightDataServiceCommon(data, ConversionUtils.Data::toBase64String);
    }

    public static String encryptByWcspLightDataServiceHex(String data) {
        return WcspEncryptUtils.executeEncryptionByWcspLightDataServiceCommon(data, ConversionUtils.Data::toHexString);
    }

    public static String decryptByWcspLightDataService(String data) {
        return WcspEncryptUtils.executeDecryptionByWcspLightDataServiceCommon(data, ConversionUtils.Data::fromBase64String);
    }

    public static String decryptByWcspLightDataServiceHex(String data) {
        return WcspEncryptUtils.executeDecryptionByWcspLightDataServiceCommon(data, ConversionUtils.Data::fromHexString);
    }

    @Generated
    private WcspEncryptUtils() {
    }

    static {
        lightDataServiceThreadLocal = new ThreadLocal();
    }
}

