/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.dy.dy.dao.dy.WorkerTrainingStaffMapper;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingStaffListParam;
import cn.smarthse.dy.dy.entity.WorkerTrainingStaff;
import cn.smarthse.dy.dy.service.dy.IWorkerTrainingStaffService;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingStaffListVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingStaffOneVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class WorkerTrainingStaffServiceImpl
extends ServiceImpl<WorkerTrainingStaffMapper, WorkerTrainingStaff>
implements IWorkerTrainingStaffService {
    @Override
    @Transactional
    public WorkerTrainingStaff saveOne(WorkerTrainingStaff workerTrainingStaff) {
        WorkerTrainingStaff entity = (WorkerTrainingStaff)((WorkerTrainingStaffMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WorkerTrainingStaff.class).eq(WorkerTrainingStaff::getName, (Object)workerTrainingStaff.getName())).eq(WorkerTrainingStaff::getIdCard, (Object)workerTrainingStaff.getIdCard())).eq(WorkerTrainingStaff::getTel, (Object)workerTrainingStaff.getTel())).eq(WorkerTrainingStaff::getIsValid, (Object)Boolean.TRUE));
        if (Objects.nonNull(entity)) {
            return entity;
        }
        workerTrainingStaff.setId(Long.valueOf(IdWorker.getId()));
        if (this.save(workerTrainingStaff)) {
            return workerTrainingStaff;
        }
        return null;
    }

    @Override
    public PageInfo<WorkerTrainingStaffListVo> getWorkerTrainingStaffPage(WorkerTrainingStaffListParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<WorkerTrainingStaffListVo> list = ((WorkerTrainingStaffMapper)this.baseMapper).getWorkerTrainingStaffList(param);
        if (CollUtil.isNotEmpty(list)) {
            Set<Long> trainingStaffIdList = list.stream().map(WorkerTrainingStaffListVo::getTrainStaffId).collect(Collectors.toSet());
            List<WorkerTrainingStaffListVo> subList = ((WorkerTrainingStaffMapper)this.baseMapper).getWorkerTrainingStaffSubList(trainingStaffIdList);
            if (CollUtil.isNotEmpty(subList)) {
                Map<Long, WorkerTrainingStaffListVo> map = subList.stream().collect(Collectors.toMap(WorkerTrainingStaffListVo::getTrainStaffId, entry -> entry, (v1, v2) -> v1));
                for (WorkerTrainingStaffListVo dto : list) {
                    if (!map.containsKey(dto.getTrainStaffId())) continue;
                    WorkerTrainingStaffListVo vo = map.get(dto.getTrainStaffId());
                    dto.setTrainBeginDate(vo.getTrainBeginDate());
                    dto.setTrainProjId(vo.getTrainProjId());
                    dto.setCid(vo.getCid());
                    dto.setCompanyName(vo.getCompanyName());
                }
            }
            list.stream().peek(i -> {
                i.setGender(Integer.valueOf(IdcardUtil.getGenderByIdCard((String)i.getIdCard())));
                i.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)i.getIdCard())));
            }).collect(Collectors.toList());
        }
        return new PageInfo(list);
    }

    @Override
    public WorkerTrainingStaffOneVo getWorkerTrainingStaffOne(Long id) {
        WorkerTrainingStaffOneVo rst = new WorkerTrainingStaffOneVo();
        WorkerTrainingStaff workerTrainingStaff = (WorkerTrainingStaff)((WorkerTrainingStaffMapper)this.baseMapper).selectById(id);
        if (Objects.nonNull(workerTrainingStaff)) {
            rst.setName(workerTrainingStaff.getName());
            rst.setIdCard(workerTrainingStaff.getIdCard());
            rst.setTel(workerTrainingStaff.getTel());
            rst.setGender(Integer.valueOf(IdcardUtil.getGenderByIdCard((String)workerTrainingStaff.getIdCard())));
            rst.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)workerTrainingStaff.getIdCard())));
        }
        return rst;
    }
}

