/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.dy.dy.dao.dy.WorkerTrainingStaffProjMapper;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingProjDetailListParam;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingStaffDetailListParam;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingStatisticsListParam;
import cn.smarthse.dy.dy.entity.WorkerTrainingStaffProj;
import cn.smarthse.dy.dy.service.dy.IWorkerTrainingStaffProjService;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingProjDetailListVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingStaffDetailListVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingStatisticsListVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingStatisticsOneVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class WorkerTrainingStaffProjServiceImpl
extends ServiceImpl<WorkerTrainingStaffProjMapper, WorkerTrainingStaffProj>
implements IWorkerTrainingStaffProjService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    public boolean ifExistByTrainProjIdAndTrainingStaffId(Long trainProjId, Long trainingStaffId) {
        return CollUtil.isNotEmpty((Collection)this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WorkerTrainingStaffProj.class).eq(WorkerTrainingStaffProj::getTrainProjId, (Object)trainProjId)).eq(WorkerTrainingStaffProj::getTrainStaffId, (Object)trainingStaffId)).eq(WorkerTrainingStaffProj::getIsValid, (Object)true)));
    }

    @Override
    @Transactional
    public boolean deleteOfflineTrainingStaff(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List workerTrainingStaffList = ((WorkerTrainingStaffProjMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(WorkerTrainingStaffProj.class).in(WorkerTrainingStaffProj::getId, idList)).eq(WorkerTrainingStaffProj::getIsValid, (Object)true));
        if (CollUtil.isEmpty((Collection)workerTrainingStaffList)) {
            throw new ServiceException("\u8be5\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        ArrayList<WorkerTrainingStaffProj> list = new ArrayList<WorkerTrainingStaffProj>(workerTrainingStaffList.size());
        for (WorkerTrainingStaffProj workerTrainingStaffProj : workerTrainingStaffList) {
            WorkerTrainingStaffProj entity = new WorkerTrainingStaffProj();
            entity.setId(workerTrainingStaffProj.getId());
            entity.setIsValid(Boolean.valueOf(false));
            entity.setUpdateBy(loginUserId);
            list.add(entity);
        }
        return this.updateBatchById(list);
    }

    @Override
    public PageInfo<WorkerTrainingProjDetailListVo> getWorkerTrainingProjDetailPage(WorkerTrainingProjDetailListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<WorkerTrainingProjDetailListVo> list = ((WorkerTrainingStaffProjMapper)this.baseMapper).getWorkerTrainingProjDetailList(param);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<WorkerTrainingStaffDetailListVo> getWorkerTrainingStaffDetailPage(WorkerTrainingStaffDetailListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<WorkerTrainingStaffDetailListVo> list = ((WorkerTrainingStaffProjMapper)this.baseMapper).getWorkerTrainingStaffDetailList(param);
        if (CollUtil.isNotEmpty(list)) {
            for (WorkerTrainingStaffDetailListVo dto : list) {
                dto.setDetailAreaName(this.sysAreaProvideService.getFullName(dto.getDetailAreaId(), ""));
            }
        }
        return new PageInfo(list);
    }

    @Override
    public PageInfo<WorkerTrainingStatisticsListVo> getWorkerTrainingStatisticsList(WorkerTrainingStatisticsListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<WorkerTrainingStatisticsListVo> list = ((WorkerTrainingStaffProjMapper)this.baseMapper).getWorkerTrainingStatisticsList(param);
        return new PageInfo(list);
    }

    @Override
    public WorkerTrainingStatisticsOneVo getWorkerTrainingStatisticsOne(WorkerTrainingStatisticsListParam param) {
        WorkerTrainingStatisticsOneVo rst = new WorkerTrainingStatisticsOneVo();
        param.setCount(Boolean.valueOf(false));
        Long areaId = param.getUserAreaId();
        byte level = (byte)Math.max(param.getUserAreaLevel() - 1, 0);
        param.setUserAreaId(this.sysAreaProvideService.getAreaByIdV3(param.getUserAreaId()).getParentId());
        param.setUserAreaLevel(Byte.valueOf(level));
        PageInfo<WorkerTrainingStatisticsListVo> pageInfo = this.getWorkerTrainingStatisticsList(param);
        List list = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return rst;
        }
        WorkerTrainingStatisticsListVo workerTrainingProj = (WorkerTrainingStatisticsListVo)list.stream().filter(i -> i.getAreaId().equals(areaId)).collect(Collectors.toList()).get(0);
        if (Objects.nonNull(workerTrainingProj)) {
            rst.setAreaId(workerTrainingProj.getAreaId());
            rst.setAreaName(workerTrainingProj.getAreaName());
            rst.setCompanyCount(workerTrainingProj.getCompanyCount());
            rst.setAttendTrainingCompanyCount(workerTrainingProj.getAttendTrainingCompanyCount());
            rst.setAttendTrainingStaffCount(workerTrainingProj.getAttendTrainingStaffCount());
            rst.setAttendTrainingCompanyCount2(workerTrainingProj.getAttendTrainingCompanyCount2());
            rst.setAttendTrainingStaffCount2(workerTrainingProj.getAttendTrainingStaffCount2());
        }
        return rst;
    }
}

