/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.smarthse.dy.dy.converter.WorkerTrainingProjConverter;
import cn.smarthse.dy.dy.dao.dy.WorkerTrainingProjMapper;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingProjAddParam;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingProjEditParam;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingProjListParam;
import cn.smarthse.dy.dy.entity.WorkerTrainingProj;
import cn.smarthse.dy.dy.service.dy.IWorkerTrainingProjService;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingProjListVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingProjOneVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingProjVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.health.enums.train.TrainProfileStatusEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class WorkerTrainingProjServiceImpl
extends ServiceImpl<WorkerTrainingProjMapper, WorkerTrainingProj>
implements IWorkerTrainingProjService {
    @Autowired
    private WorkerTrainingProjConverter workerTrainingProjConverter;
    @Value(value="${applications.url.worker.sign.in}")
    private String applicationsUrlWorkerSignIn;

    @Override
    public WorkerTrainingProjVo getWorkerTrainingProjById(Long id) {
        return ((WorkerTrainingProjMapper)this.baseMapper).getWorkerTrainingProjById(id);
    }

    @Override
    public PageInfo<WorkerTrainingProjListVo> getWorkerTrainingProjPage(WorkerTrainingProjListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<WorkerTrainingProjListVo> list = ((WorkerTrainingProjMapper)this.baseMapper).getList(param);
        list.stream().peek(i -> {
            if (TrainProfileStatusEnum.PASSED.getValue().equals(i.getTrainProfileStatus())) {
                i.setSignInQrCode(this.getQr(this.applicationsUrlWorkerSignIn, i.getId()));
            }
        }).collect(Collectors.toList());
        return new PageInfo(list);
    }

    private String getQr(String url, Long id) {
        long expireDurationMinutes = 5L;
        long expireTimeMillis = System.currentTimeMillis() + expireDurationMinutes * 60L * 1000L;
        return QrCodeUtil.generateAsBase64((String)(url + "?timestamp=" + expireTimeMillis + "&id=" + id), (QrConfig)new QrConfig(), (String)"png");
    }

    @Override
    public WorkerTrainingProjOneVo getWorkerTrainingProjOne(Long id) {
        WorkerTrainingProjOneVo rst = new WorkerTrainingProjOneVo();
        WorkerTrainingProjListParam param = new WorkerTrainingProjListParam();
        param.setCount(Boolean.valueOf(false));
        param.setId(id);
        PageInfo<WorkerTrainingProjListVo> pageInfo = this.getWorkerTrainingProjPage(param);
        WorkerTrainingProjListVo workerTrainingProj = (WorkerTrainingProjListVo)pageInfo.getList().get(0);
        if (Objects.nonNull(workerTrainingProj)) {
            rst.setId(workerTrainingProj.getId());
            rst.setCid(workerTrainingProj.getCid());
            rst.setCompanyName(workerTrainingProj.getCompanyName());
            rst.setCreditCode(workerTrainingProj.getCreditCode());
            rst.setTrainProjName(workerTrainingProj.getTrainProjName());
            rst.setTrainPublishUnitId(workerTrainingProj.getTrainPublishUnitId());
            rst.setTrainPublishUnit(workerTrainingProj.getTrainPublishUnit());
            rst.setSignInNums(workerTrainingProj.getSignInNums());
            rst.setSignInQrCode(workerTrainingProj.getSignInQrCode());
            rst.setTrainBeginDate(workerTrainingProj.getTrainBeginDate());
            rst.setTrainEndDate(workerTrainingProj.getTrainEndDate());
            rst.setTrainContent(workerTrainingProj.getTrainContent());
        }
        return rst;
    }

    @Override
    @Transactional
    public boolean saveWorkerTrainingProj(WorkerTrainingProjAddParam param) {
        if (TrainProfileStatusEnum.PASSED.getValue().equals(param.getTrainProfileStatus())) {
            if (StrUtil.isBlank((CharSequence)param.getTrainProjName())) {
                throw new ServiceException("\u57f9\u8bad\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainPublishUnitId())) {
                throw new ServiceException("\u57f9\u8bad\u53d1\u5e03\u5355\u4f4dId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainPublishUnit())) {
                throw new ServiceException("\u57f9\u8bad\u53d1\u5e03\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainBeginDate())) {
                throw new ServiceException("\u57f9\u8bad\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainEndDate())) {
                throw new ServiceException("\u57f9\u8bad\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getCid())) {
                throw new ServiceException("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainContent())) {
                throw new ServiceException("\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        WorkerTrainingProj entity = this.workerTrainingProjConverter.addParam2Entity(param);
        entity.setSubAreaId(param.getUserAreaId());
        entity.setCreateBy(param.getLoginUserId());
        entity.setUpdateBy(param.getLoginUserId());
        return this.save(entity);
    }

    @Override
    @Transactional
    public boolean updateWorkerTrainingProj(WorkerTrainingProjEditParam param) {
        if (Objects.isNull(param.getId())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WorkerTrainingProj workerTrainingProj = (WorkerTrainingProj)this.getById(param.getId());
        if (Objects.isNull(workerTrainingProj)) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(workerTrainingProj.getTrainProfileStatus(), TrainProfileStatusEnum.DRAFT.getValue())) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91");
        }
        if (TrainProfileStatusEnum.PASSED.getValue().equals(param.getTrainProfileStatus())) {
            if (StrUtil.isBlank((CharSequence)param.getTrainProjName())) {
                throw new ServiceException("\u57f9\u8bad\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainPublishUnitId())) {
                throw new ServiceException("\u57f9\u8bad\u53d1\u5e03\u5355\u4f4dId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainPublishUnit())) {
                throw new ServiceException("\u57f9\u8bad\u53d1\u5e03\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainBeginDate())) {
                throw new ServiceException("\u57f9\u8bad\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainEndDate())) {
                throw new ServiceException("\u57f9\u8bad\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getCid())) {
                throw new ServiceException("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainContent())) {
                throw new ServiceException("\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        WorkerTrainingProj entity = this.workerTrainingProjConverter.editParam2Entity(param);
        entity.setUpdateBy(param.getLoginUserId());
        return this.updateById(entity);
    }

    @Override
    @Transactional
    public boolean deleteOfflineTrainingProj(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List workerTrainingProjList = ((WorkerTrainingProjMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(WorkerTrainingProj.class).in(WorkerTrainingProj::getId, idList)).eq(WorkerTrainingProj::getIsValid, (Object)true));
        if (CollUtil.isEmpty((Collection)workerTrainingProjList)) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        ArrayList<WorkerTrainingProj> list = new ArrayList<WorkerTrainingProj>(idList.size());
        for (Long id : idList) {
            WorkerTrainingProj entity = new WorkerTrainingProj();
            entity.setId(id);
            entity.setIsValid(Boolean.valueOf(false));
            entity.setUpdateBy(loginUserId);
            list.add(entity);
        }
        return this.updateBatchById(list);
    }
}

