/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.dy.dy.dao.dy.OfflineTrainingStaffMapper;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrAddParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrEditParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrListParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrSignInParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrSignOutParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingStaffListParam;
import cn.smarthse.dy.dy.entity.OfflineTrainingStaff;
import cn.smarthse.dy.dy.manager.CertificateManager;
import cn.smarthse.dy.dy.service.dy.IMasService;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingStaffService;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingCertificateVo;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingQrListVo;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingStaffListVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class OfflineTrainingStaffServiceImpl
extends ServiceImpl<OfflineTrainingStaffMapper, OfflineTrainingStaff>
implements IOfflineTrainingStaffService {
    @Lazy
    @Autowired
    private CertificateManager certificateManager;
    @Autowired
    private IMasService masService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public PageInfo<OfflineTrainingStaffListVo> getPage(OfflineTrainingStaffListParam param) {
        List certificateStaffDetailIdList;
        List sysFileModelList;
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OfflineTrainingStaffListVo> list = ((OfflineTrainingStaffMapper)this.baseMapper).getList(param);
        if (CollUtil.isNotEmpty(list) && CollUtil.isNotEmpty((Collection)(sysFileModelList = this.sysFileProvideService.getListByIds(certificateStaffDetailIdList = list.stream().filter(item -> Objects.nonNull(item.getSignOutTime()) && Objects.nonNull(item.getFileId())).map(OfflineTrainingStaffListVo::getFileId).collect(Collectors.toList()))))) {
            Map<Long, SysFileModel> sysFileModelMap = sysFileModelList.stream().collect(Collectors.toMap(SysFileModel::getId, item -> item, (v1, v2) -> v1));
            list.stream().peek(i -> i.setSysFileModel((SysFileModel)sysFileModelMap.get(i.getFileId()))).collect(Collectors.toList());
        }
        return new PageInfo(list);
    }

    @Override
    @Transactional
    public Boolean deleteOfflineTrainingStaff(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List offlineTrainingStaffList = ((OfflineTrainingStaffMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(OfflineTrainingStaff.class).in(OfflineTrainingStaff::getId, idList)).eq(OfflineTrainingStaff::getIsValid, (Object)true));
        if (CollUtil.isEmpty((Collection)offlineTrainingStaffList)) {
            throw new ServiceException("\u8be5\u4eba\u5458\u6863\u6848\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        if (CollUtil.isEmpty(offlineTrainingStaffList = offlineTrainingStaffList.stream().filter(i -> Objects.isNull(i.getSignOutTime())).collect(Collectors.toList()))) {
            throw new ServiceException("\u5df2\u5b58\u5728\u57f9\u8bad\u8bc1\u4e66\u65e0\u6cd5\u5220\u9664");
        }
        ArrayList<OfflineTrainingStaff> list = new ArrayList<OfflineTrainingStaff>(offlineTrainingStaffList.size());
        Date date = new Date();
        for (OfflineTrainingStaff offlineTrainingStaff : offlineTrainingStaffList) {
            OfflineTrainingStaff entity = new OfflineTrainingStaff();
            entity.setId(offlineTrainingStaff.getId());
            entity.setIsValid(Boolean.valueOf(false));
            entity.setUpdateBy(loginUserId);
            entity.setUpdateDate(date);
            list.add(entity);
        }
        return this.updateBatchById(list);
    }

    @Override
    public PageInfo<OfflineTrainingQrListVo> getOfflineTrainingQrPage(OfflineTrainingQrListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(this.getOfflineTrainingQrList(param));
    }

    @Override
    public List<OfflineTrainingQrListVo> getOfflineTrainingQrList(OfflineTrainingQrListParam param) {
        return ((OfflineTrainingStaffMapper)this.baseMapper).getOfflineTrainingQrList(param);
    }

    @Override
    @Transactional
    public Boolean saveOfflineTrainingQr(OfflineTrainingQrAddParam param) {
        List trainPersonnelTypeList = StringUtils.parseToLongList((String)param.getTrainPersonnelType());
        if (CollUtil.isEmpty((Collection)trainPersonnelTypeList)) {
            throw new ServiceException("\u57f9\u8bad\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        trainPersonnelTypeList = trainPersonnelTypeList.stream().distinct().collect(Collectors.toList());
        Date date = new Date();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(OfflineTrainingStaff.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard())).eq(OfflineTrainingStaff::getCid, (Object)param.getCid())).in(OfflineTrainingStaff::getTrainPersonnelType, trainPersonnelTypeList);
        List list = this.list((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            if (list.stream().anyMatch(i -> Objects.nonNull(i.getSignOutTime()))) {
                throw new ServiceException("\u65b0\u589e\u5931\u8d25\uff0c\u6240\u9009\u7684\u4eba\u5458\u7c7b\u578b\u4e2d\u5df2\u5b58\u5728\u7b7e\u9000\u7684\u60c5\u51b5");
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper(OfflineTrainingStaff.class);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard())).eq(OfflineTrainingStaff::getCid, (Object)param.getCid())).in(OfflineTrainingStaff::getTrainPersonnelType, trainPersonnelTypeList)).set(OfflineTrainingStaff::getIsValid, (Object)Boolean.FALSE)).set(OfflineTrainingStaff::getUpdateDate, (Object)date);
            this.update((Wrapper)wrapper2);
        }
        ArrayList<OfflineTrainingStaff> entityList = new ArrayList<OfflineTrainingStaff>(2);
        for (Long l : trainPersonnelTypeList) {
            OfflineTrainingStaff entity = new OfflineTrainingStaff();
            entity.setTrainProjId(param.getTrainProjId());
            entity.setName(param.getName());
            entity.setIdCard(param.getIdCard());
            entity.setTel(param.getTel());
            entity.setCid(param.getCid());
            entity.setCompanyName(param.getCompanyName());
            entity.setAreaId(Long.valueOf(330783000000L));
            entity.setTrainPersonnelType(l);
            entity.setCreateDate(date);
            entity.setUpdateDate(date);
            entityList.add(entity);
        }
        return this.saveBatch(entityList);
    }

    @Override
    @Transactional
    public Boolean updateOfflineTrainingQr(OfflineTrainingQrEditParam param) {
        List trainPersonnelTypeList = StringUtils.parseToLongList((String)param.getTrainPersonnelType());
        if (CollUtil.isEmpty((Collection)trainPersonnelTypeList)) {
            throw new ServiceException("\u57f9\u8bad\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        trainPersonnelTypeList = trainPersonnelTypeList.stream().distinct().collect(Collectors.toList());
        Date date = new Date();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(OfflineTrainingStaff.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard())).eq(OfflineTrainingStaff::getCid, (Object)param.getCid());
        List list = this.list((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            if (list.stream().anyMatch(i -> Objects.nonNull(i.getSignOutTime()))) {
                throw new ServiceException("\u4fee\u6539\u5931\u8d25\uff0c\u6240\u4fee\u6539\u7684\u4eba\u5458\u7c7b\u578b\u4e2d\u5df2\u5b58\u5728\u7b7e\u9000\u7684\u60c5\u51b5");
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper(OfflineTrainingStaff.class);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard())).eq(OfflineTrainingStaff::getCid, (Object)param.getCid())).set(OfflineTrainingStaff::getIsValid, (Object)Boolean.FALSE)).set(OfflineTrainingStaff::getUpdateDate, (Object)date);
            this.update((Wrapper)wrapper2);
        }
        ArrayList<OfflineTrainingStaff> entityList = new ArrayList<OfflineTrainingStaff>(2);
        for (Long l : trainPersonnelTypeList) {
            OfflineTrainingStaff entity = new OfflineTrainingStaff();
            entity.setTrainProjId(param.getTrainProjId());
            entity.setName(param.getName());
            entity.setIdCard(param.getIdCard());
            entity.setTel(param.getTel());
            entity.setCid(param.getCid());
            entity.setCompanyName(param.getCompanyName());
            entity.setAreaId(Long.valueOf(330783000000L));
            entity.setTrainPersonnelType(l);
            entity.setCreateDate(date);
            entity.setUpdateDate(date);
            entityList.add(entity);
        }
        return this.saveBatch(entityList);
    }

    @Override
    @Transactional
    public Boolean signIn(OfflineTrainingQrSignInParam param) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(OfflineTrainingStaff.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard());
        List list = this.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            this.log.warn("\u7b7e\u5230\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u53c2\u4e0e\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a" + param.getName() + "\uff1bidCard\uff1a" + param.getIdCard());
            return Boolean.FALSE;
        }
        List needSignInList = list.stream().filter(i -> Objects.isNull(i.getSignOutTime())).collect(Collectors.toList());
        if (CollUtil.isEmpty(needSignInList)) {
            this.log.warn("\u7b7e\u5230\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u7b7e\u5230\u7684\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a" + param.getName() + "\uff1bidCard\uff1a" + param.getIdCard());
            return Boolean.FALSE;
        }
        Date date = new Date();
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper(OfflineTrainingStaff.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.in(OfflineTrainingStaff::getId, (Collection)needSignInList.stream().map(OfflineTrainingStaff::getId).collect(Collectors.toList()))).set(OfflineTrainingStaff::getSignInTime, (Object)date)).set(OfflineTrainingStaff::getUpdateDate, (Object)date);
        return this.update((Wrapper)wrapper2);
    }

    @Override
    @Transactional
    public Boolean signOut(OfflineTrainingQrSignOutParam param) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(OfflineTrainingStaff.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(OfflineTrainingStaff::getTrainProjId, (Object)param.getTrainProjId())).eq(OfflineTrainingStaff::getIsValid, (Object)Boolean.TRUE)).eq(OfflineTrainingStaff::getName, (Object)param.getName())).eq(OfflineTrainingStaff::getIdCard, (Object)param.getIdCard());
        List list = this.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            this.log.warn(String.format("\u7b7e\u9000\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u7b7e\u5230\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a%s\uff1bidCard\uff1a%s", param.getName(), param.getIdCard()));
            throw new ServiceException(String.format("\u7b7e\u9000\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u7b7e\u5230\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a%s\uff1bidCard\uff1a%s", param.getName(), param.getIdCard()));
        }
        List needSignOutList = list.stream().filter(i -> Objects.nonNull(i.getSignInTime()) && Objects.isNull(i.getSignOutTime())).collect(Collectors.toList());
        if (CollUtil.isEmpty(needSignOutList)) {
            this.log.warn(String.format("\u7b7e\u9000\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u7b7e\u9000\u7684\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a%s\uff1bidCard\uff1a%s", param.getName(), param.getIdCard()));
            throw new ServiceException(String.format("\u7b7e\u9000\u5931\u8d25\uff0c\u8be5\u4eba\u5458\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u7b7e\u9000\u7684\u8be5\u57f9\u8bad\u9879\u76ee\u76f8\u5173\u4fe1\u606f\uff0cname\uff1a%s\uff1bidCard\uff1a%s", param.getName(), param.getIdCard()));
        }
        Date date = new Date();
        Integer year = LocalDateTime.now().getYear();
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper(OfflineTrainingStaff.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.in(OfflineTrainingStaff::getId, (Collection)needSignOutList.stream().map(OfflineTrainingStaff::getId).collect(Collectors.toList()))).set(OfflineTrainingStaff::getSignOutTime, (Object)date)).set(OfflineTrainingStaff::getYear, (Object)year)).set(OfflineTrainingStaff::getUpdateDate, (Object)date);
        boolean b = this.update((Wrapper)wrapper2);
        if (b) {
            this.threadPoolTaskExecutor.execute(() -> this.signOutSubTask(param, needSignOutList, year));
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void signOutSubTask(OfflineTrainingQrSignOutParam param, List<OfflineTrainingStaff> needSignOutList, Integer year) {
        ArrayList<Long> idsToGenerateCertificate = new ArrayList<Long>(needSignOutList.size());
        for (OfflineTrainingStaff offlineTrainingStaff : needSignOutList) {
            RLock rLock = this.redissonClient.getLock(String.format("offlineTrainingStaffServiceGetMaxSerialNo%s%s", offlineTrainingStaff.getTrainPersonnelType(), year));
            try {
                if (!rLock.tryLock(5L, TimeUnit.MINUTES)) continue;
                boolean b = false;
                try {
                    b = this.updateSignOutInfo(year, offlineTrainingStaff);
                }
                catch (Exception e) {
                    this.log.error(String.format("trainProjId\uff1a%s idCard\uff1a%s name\uff1a%s \u7b7e\u5230\u7ed3\u675f\u540e\u7eed\u6570\u636e\u8865\u5145\u4efb\u52a1\u3010\u751f\u6210\u6d41\u6c34\u53f7\u3001\u8bc1\u4e66\u7f16\u53f7\u3011\u5f02\u5e38\u5931\u8d25\uff1a%s", param.getTrainProjId(), param.getIdCard(), param.getName(), e));
                }
                finally {
                    if (!b) {
                        // empty if block
                    }
                }
                if (!b) continue;
                idsToGenerateCertificate.add(offlineTrainingStaff.getId());
            }
            catch (Exception e) {
                this.log.error("\u7ebf\u4e0b\u57f9\u8bad\u7b7e\u9000\u5b50\u4efb\u52a1\u9501\u5f02\u5e38\uff1a", (Throwable)e);
            }
            finally {
                rLock.unlock();
            }
        }
        if (!idsToGenerateCertificate.isEmpty()) {
            try {
                this.certificateManager.generateCertificateV1(idsToGenerateCertificate);
            }
            catch (Exception e) {
                this.log.error(String.format("trainProjId\uff1a%s idCard\uff1a%s name\uff1a%s \u7b7e\u5230\u7ed3\u675f\u540e\u7eed\u6570\u636e\u8865\u5145\u4efb\u52a1\u3010\u751f\u6210\u8bc1\u4e66\u3011\u5931\u8d25\uff1a%s", param.getTrainProjId(), param.getIdCard(), param.getName(), e));
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean updateSignOutInfo(Integer year, OfflineTrainingStaff offlineTrainingStaff) {
        OfflineTrainingStaff entity = new OfflineTrainingStaff();
        entity.setId(offlineTrainingStaff.getId());
        entity.setSerialNo(Integer.valueOf(this.getMaxSerialNo(offlineTrainingStaff.getAreaId(), year, offlineTrainingStaff.getTrainPersonnelType()) + 1));
        entity.setCertificateNo(offlineTrainingStaff.getAreaId().toString().substring(0, 6) + CertificateStaffNameTypeEnum.getIdentificationById((Long)offlineTrainingStaff.getTrainPersonnelType()) + year.toString().substring(year.toString().length() - 2) + String.format("%06d", entity.getSerialNo()));
        return this.updateById(entity);
    }

    @Override
    public List<OfflineTrainingCertificateVo> getGeneralCertificateVoList(List<Long> offlineTrainingStaffIdList) {
        if (CollUtil.isEmpty(offlineTrainingStaffIdList)) {
            return Collections.emptyList();
        }
        return ((OfflineTrainingStaffMapper)this.baseMapper).getGeneralCertificateVoList(offlineTrainingStaffIdList);
    }

    @Override
    public int getMaxSerialNo(Long areaId, Integer year, Long trainPersonnelType) {
        int maxSerialNo = ((OfflineTrainingStaffMapper)this.baseMapper).getMaxSerialNo(areaId, year, trainPersonnelType);
        return maxSerialNo < 500000 ? maxSerialNo + 500000 : maxSerialNo;
    }

    @Override
    @Transactional
    public void updateFileIdById(Long id, Long fileId) {
        if (Objects.isNull(id) || Objects.isNull(fileId)) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper(OfflineTrainingStaff.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(OfflineTrainingStaff::getId, (Object)id)).set(OfflineTrainingStaff::getFileId, (Object)fileId)).set(OfflineTrainingStaff::getUpdateDate, (Object)new Date());
        this.update((Wrapper)wrapper);
    }
}

