/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.smarthse.dy.dy.converter.OfflineTrainingProjConverter;
import cn.smarthse.dy.dy.dao.dy.OfflineTrainingProjMapper;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingProjAddParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingProjEditParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingProjListParam;
import cn.smarthse.dy.dy.entity.OfflineTrainingProj;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingProjService;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingProjListVo;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingProjOneVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainProfileStatusEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class OfflineTrainingProjServiceImpl
extends ServiceImpl<OfflineTrainingProjMapper, OfflineTrainingProj>
implements IOfflineTrainingProjService {
    @Autowired
    private OfflineTrainingProjConverter offlineTrainingProjConverter;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Value(value="${applications.url.offline.sign.in}")
    private String applicationsUrlOfflineSignIn;
    @Value(value="${applications.url.offline.sign.out}")
    private String applicationsUrlOfflineSignOut;

    @Override
    public PageInfo<OfflineTrainingProjListVo> getPage(OfflineTrainingProjListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<OfflineTrainingProjListVo> list = ((OfflineTrainingProjMapper)this.baseMapper).getList(param);
        list.stream().peek(i -> {
            if (TrainProfileStatusEnum.PASSED.getValue().equals(i.getTrainProfileStatus())) {
                i.setSignInQrCode(this.getQr(this.applicationsUrlOfflineSignIn, i.getId()));
                i.setSignOutQrCode(this.getQr(this.applicationsUrlOfflineSignOut, i.getId()));
            }
        }).collect(Collectors.toList());
        return new PageInfo(list);
    }

    @Override
    public OfflineTrainingProj getOfflineTrainingProjById(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(OfflineTrainingProj.class);
        ((LambdaQueryWrapper)wrapper.eq(OfflineTrainingProj::getId, (Object)id)).eq(OfflineTrainingProj::getIsValid, (Object)Boolean.TRUE);
        return (OfflineTrainingProj)this.getOne((Wrapper)wrapper);
    }

    @Override
    public OfflineTrainingProjOneVo getOne(Long id) {
        OfflineTrainingProjOneVo rst = new OfflineTrainingProjOneVo();
        OfflineTrainingProj offlineTrainingProj = (OfflineTrainingProj)((OfflineTrainingProjMapper)this.baseMapper).selectById(id);
        if (Objects.nonNull(offlineTrainingProj)) {
            rst.setTrainProjName(offlineTrainingProj.getTrainProjName());
            rst.setTrainBeginDate(offlineTrainingProj.getTrainBeginDate());
            rst.setTrainEndDate(offlineTrainingProj.getTrainEndDate());
            rst.setTrainPersonnelType(offlineTrainingProj.getTrainPersonnelType());
            rst.setTrainPersonnelTypeMap(this.buildTrainPersonnelTypeMap(offlineTrainingProj.getTrainPersonnelType()));
            rst.setTrainAreaId(offlineTrainingProj.getTrainAreaId());
            rst.setTrainAreaName(this.sysAreaProvideService.getAreaByIdV3(rst.getTrainAreaId()).getName());
            rst.setTrainContent(offlineTrainingProj.getTrainContent());
            rst.setTrainPublishUnit(offlineTrainingProj.getTrainPublishUnit());
            if (TrainProfileStatusEnum.PASSED.getValue().equals(offlineTrainingProj.getTrainProfileStatus())) {
                rst.setSignInQrCode(this.getQr(this.applicationsUrlOfflineSignIn, id));
                rst.setSignOutQrCode(this.getQr(this.applicationsUrlOfflineSignOut, id));
            }
        }
        return rst;
    }

    private Map<Long, String> buildTrainPersonnelTypeMap(String trainPersonnelType) {
        return Arrays.stream(trainPersonnelType.split(",")).filter(CharSequenceUtil::isNotBlank).mapToLong(s -> {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }).boxed().collect(Collectors.toMap(i -> i, CertificateStaffNameTypeEnum::getNameTypeById, (v1, v2) -> v1));
    }

    private String getQr(String url, Long id) {
        long expireDurationMinutes = 5L;
        long expireTimeMillis = System.currentTimeMillis() + expireDurationMinutes * 60L * 1000L;
        return QrCodeUtil.generateAsBase64((String)(url + "?timestamp=" + expireTimeMillis + "&id=" + id), (QrConfig)new QrConfig(), (String)"png");
    }

    @Override
    @Transactional
    public Boolean saveOfflineTrainingProj(OfflineTrainingProjAddParam param) {
        if (TrainProfileStatusEnum.PASSED.getValue().equals(param.getTrainProfileStatus())) {
            if (StrUtil.isBlank((CharSequence)param.getTrainProjName())) {
                throw new ServiceException("\u57f9\u8bad\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainBeginDate())) {
                throw new ServiceException("\u57f9\u8bad\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainEndDate())) {
                throw new ServiceException("\u57f9\u8bad\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainPersonnelType())) {
                throw new ServiceException("\u57f9\u8bad\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainContent())) {
                throw new ServiceException("\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        OfflineTrainingProj entity = this.offlineTrainingProjConverter.addParam2Entity(param);
        entity.setCreateBy(param.getLoginUserId());
        entity.setUpdateBy(param.getLoginUserId());
        Date date = new Date();
        entity.setCreateDate(date);
        entity.setUpdateDate(date);
        return this.save(entity);
    }

    @Override
    @Transactional
    public Boolean updateOfflineTrainingProj(OfflineTrainingProjEditParam param) {
        if (Objects.isNull(param.getId())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OfflineTrainingProj offlineTrainingProj = (OfflineTrainingProj)this.getById(param.getId());
        if (Objects.isNull(offlineTrainingProj)) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(offlineTrainingProj.getTrainProfileStatus(), TrainProfileStatusEnum.DRAFT.getValue())) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91");
        }
        if (TrainProfileStatusEnum.PASSED.getValue().equals(param.getTrainProfileStatus())) {
            if (StrUtil.isBlank((CharSequence)param.getTrainProjName())) {
                throw new ServiceException("\u57f9\u8bad\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainBeginDate())) {
                throw new ServiceException("\u57f9\u8bad\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(param.getTrainEndDate())) {
                throw new ServiceException("\u57f9\u8bad\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainPersonnelType())) {
                throw new ServiceException("\u57f9\u8bad\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)param.getTrainContent())) {
                throw new ServiceException("\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        OfflineTrainingProj entity = this.offlineTrainingProjConverter.editParam2Entity(param);
        entity.setUpdateBy(param.getLoginUserId());
        entity.setUpdateDate(new Date());
        return this.updateById(entity);
    }

    @Override
    @Transactional
    public Boolean deleteOfflineTrainingProj(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List offlineTrainingProjList = ((OfflineTrainingProjMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(OfflineTrainingProj.class).in(OfflineTrainingProj::getId, idList)).eq(OfflineTrainingProj::getIsValid, (Object)true));
        if (CollUtil.isEmpty((Collection)offlineTrainingProjList)) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u6863\u6848\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        ArrayList<OfflineTrainingProj> list = new ArrayList<OfflineTrainingProj>(idList.size());
        Date date = new Date();
        for (Long id : idList) {
            OfflineTrainingProj entity = new OfflineTrainingProj();
            entity.setId(id);
            entity.setIsValid(Boolean.valueOf(false));
            entity.setUpdateBy(loginUserId);
            entity.setUpdateDate(date);
            list.add(entity);
        }
        return this.updateBatchById(list);
    }
}

