/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.service.dy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.dy.dy.dao.dy.DyOrganizationUserMapper;
import cn.smarthse.dy.dy.dto.PersonnelListParam;
import cn.smarthse.dy.dy.dto.api.PersonnelDto;
import cn.smarthse.dy.dy.dto.home.DyHomePersonnelParam;
import cn.smarthse.dy.dy.entity.DyOrganizationUser;
import cn.smarthse.dy.dy.entity.DyUserRole;
import cn.smarthse.dy.dy.service.dy.IDyOrganizationUserService;
import cn.smarthse.dy.dy.service.dy.IDyUserRoleService;
import cn.smarthse.dy.dy.vo.PersonnelListVo;
import cn.smarthse.dy.dy.vo.home.DyHomePersonnelDetailVo;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class DyOrganizationUserServiceImpl
extends ServiceImpl<DyOrganizationUserMapper, DyOrganizationUser>
implements IDyOrganizationUserService {
    @Autowired
    private IDyUserRoleService userRoleService;

    @Override
    @Transactional
    public Boolean pushAndRenewMultiple(List<PersonnelDto> list) {
        if (CollUtil.isEmpty(list)) {
            return Boolean.FALSE;
        }
        Set dataSourceIdSet = list.stream().map(PersonnelDto::getDataSourceId).collect(Collectors.toSet());
        if (dataSourceIdSet.size() < list.size()) {
            throw new ServiceException("\u672c\u6b21\u63a8\u9001\u6570\u636e\u7ec4\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\u6765\u6e90ID");
        }
        Set nameSet = list.stream().map(PersonnelDto::getTel).collect(Collectors.toSet());
        if (nameSet.size() < list.size()) {
            throw new ServiceException("\u672c\u6b21\u63a8\u9001\u6570\u636e\u7ec4\u4e2d\u5b58\u5728\u91cd\u590d\u624b\u673a\u53f7");
        }
        Date now = new Date();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(DyOrganizationUser.class);
        wrapper.in(DyOrganizationUser::getDataSourceId, dataSourceIdSet);
        List oldUserList = this.list((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)oldUserList)) {
            List updateList = list.stream().filter(i -> oldUserList.stream().anyMatch(j -> Objects.equals(j.getDataSourceId(), i.getDataSourceId()))).collect(Collectors.toList());
            Map<String, PersonnelDto> updateMap = updateList.stream().collect(Collectors.toMap(PersonnelDto::getDataSourceId, item -> item, (v1, v2) -> v1));
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper(DyUserRole.class);
            ((LambdaQueryWrapper)wrapper2.in(DyUserRole::getUserId, (Collection)oldUserList.stream().map(DyOrganizationUser::getId).collect(Collectors.toList()))).eq(DyUserRole::getIsValid, (Object)Boolean.TRUE);
            DyUserRole userRole2 = new DyUserRole();
            userRole2.setIsValid(Boolean.FALSE);
            userRole2.setUpdateDate(now);
            this.userRoleService.update(userRole2, (Wrapper)wrapper2);
            ArrayList<DyUserRole> addRoleList = new ArrayList<DyUserRole>(updateList.size());
            for (DyOrganizationUser user : oldUserList) {
                PersonnelDto dto = updateMap.get(user.getDataSourceId());
                user.setAreaId(dto.getAreaId());
                user.setOrganizationName(dto.getOrganizationName());
                user.setFullName(dto.getFullName());
                user.setTel(dto.getTel());
                user.setRole(dto.getRoleList().stream().map(String::valueOf).collect(Collectors.joining(",")));
                user.setAccountId(dto.getAccountId());
                user.setDataSourceId(dto.getDataSourceId());
                user.setIsValid(dto.getIsValid());
                user.setUpdateDate(now);
                for (Long roleId : dto.getRoleList()) {
                    DyUserRole userRole = new DyUserRole();
                    userRole.setRoleId(roleId);
                    userRole.setUserId(user.getId());
                    userRole.setIsValid(Boolean.TRUE);
                    userRole.setCreateDate(now);
                    userRole.setUpdateDate(now);
                    addRoleList.add(userRole);
                }
            }
            this.updateBatchById(oldUserList);
            this.userRoleService.saveBatch(addRoleList);
            list = list.stream().filter(i -> oldUserList.stream().noneMatch(j -> Objects.equals(j.getDataSourceId(), i.getDataSourceId()))).collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(list)) {
            ArrayList<DyOrganizationUser> addUserList = new ArrayList<DyOrganizationUser>(list.size());
            ArrayList<DyUserRole> addRoleList = new ArrayList<DyUserRole>(list.size());
            for (PersonnelDto dto : list) {
                DyOrganizationUser user = new DyOrganizationUser();
                user.setId(Long.valueOf(IdWorker.getId()));
                user.setAreaId(dto.getAreaId());
                user.setOrganizationName(dto.getOrganizationName());
                user.setFullName(dto.getFullName());
                user.setTel(dto.getTel());
                user.setRole(dto.getRoleList().stream().map(String::valueOf).collect(Collectors.joining(",")));
                user.setAccountId(dto.getAccountId());
                user.setDataSourceId(dto.getDataSourceId());
                user.setIsValid(dto.getIsValid());
                user.setCreateDate(now);
                user.setUpdateDate(now);
                addUserList.add(user);
                for (Long roleId : dto.getRoleList()) {
                    DyUserRole userRole = new DyUserRole();
                    userRole.setRoleId(roleId);
                    userRole.setUserId(user.getId());
                    userRole.setIsValid(Boolean.TRUE);
                    userRole.setCreateDate(now);
                    userRole.setUpdateDate(now);
                    addRoleList.add(userRole);
                }
            }
            this.saveBatch(addUserList);
            this.userRoleService.saveBatch(addRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public PageInfo<PersonnelListVo> getList(PersonnelListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((DyOrganizationUserMapper)this.baseMapper).getList(param));
    }

    @Override
    public Integer getHomePersonnelNums(DyHomePersonnelParam param) {
        return ((DyOrganizationUserMapper)this.baseMapper).getHomePersonnelNums(param);
    }

    @Override
    public String getHomePersonData2(DyHomePersonnelParam param) {
        Integer patrolTotalNum = ((DyOrganizationUserMapper)this.baseMapper).getPatrolTotalNum(param);
        Integer personNum = ((DyOrganizationUserMapper)this.baseMapper).getHomePersonnelNums(param);
        if (patrolTotalNum == null || patrolTotalNum == 0 || personNum == null || personNum == 0) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format((double)patrolTotalNum.intValue() / (double)personNum.intValue());
    }

    @Override
    public DyOrganizationUser getOneByDataSourceId(String dataSourceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(DyOrganizationUser.class);
        ((LambdaQueryWrapper)wrapper.eq(DyOrganizationUser::getDataSourceId, (Object)dataSourceId)).eq(DyOrganizationUser::getIsValid, (Object)Boolean.TRUE);
        return (DyOrganizationUser)this.getOne((Wrapper)wrapper);
    }

    @Override
    public PageInfo<DyHomePersonnelDetailVo> listPersonPatrolNum(DyHomePersonnelParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((DyOrganizationUserMapper)this.baseMapper).listPersonPatrolNum(param));
    }
}

