/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrAddParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrEditParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrListParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrSignInParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingQrSignOutParam;
import cn.smarthse.dy.dy.entity.OfflineTrainingProj;
import cn.smarthse.dy.dy.entity.OfflineTrainingStaff;
import cn.smarthse.dy.dy.manager.CertificateManager;
import cn.smarthse.dy.dy.provider.IOfflineTrainingQrProviderService;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingProjService;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingStaffService;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingQrListVo;
import java.time.LocalDateTime;
import java.util.Collections;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@DubboService
public class OfflineTrainingQrProviderServiceImpl
implements IOfflineTrainingQrProviderService {
    @Autowired
    private IOfflineTrainingProjService offlineTrainingProjService;
    @Autowired
    private IOfflineTrainingStaffService offlineTrainingStaffService;
    @Lazy
    @Autowired
    private CertificateManager certificateManager;

    public JqGridData<OfflineTrainingQrListVo> getOfflineTrainingQrList(OfflineTrainingQrListParam param) {
        return new JqGridData(this.offlineTrainingStaffService.getOfflineTrainingQrPage(param), (JqGridParam)param);
    }

    public OfflineTrainingProj getOfflineTrainingProjById(Long id) {
        return this.offlineTrainingProjService.getOfflineTrainingProjById(id);
    }

    public Boolean saveOfflineTrainingQr(OfflineTrainingQrAddParam param) {
        return this.offlineTrainingStaffService.saveOfflineTrainingQr(param);
    }

    public Boolean updateOfflineTrainingQr(OfflineTrainingQrEditParam param) {
        return this.offlineTrainingStaffService.updateOfflineTrainingQr(param);
    }

    public Boolean signIn(OfflineTrainingQrSignInParam param) {
        return this.offlineTrainingStaffService.signIn(param);
    }

    public Boolean signOut(OfflineTrainingQrSignOutParam param) {
        return this.offlineTrainingStaffService.signOut(param);
    }

    public Boolean regeneration(Long id) {
        this.certificateManager.generateCertificateV1(Collections.singletonList(id));
        return Boolean.TRUE;
    }

    public void reSignOutSubTask(Long id) {
        OfflineTrainingStaff offlineTrainingStaff = (OfflineTrainingStaff)this.offlineTrainingStaffService.getById(id);
        OfflineTrainingQrSignOutParam param = new OfflineTrainingQrSignOutParam();
        param.setTrainProjId(offlineTrainingStaff.getTrainProjId());
        param.setName(offlineTrainingStaff.getName());
        param.setIdCard(offlineTrainingStaff.getIdCard());
        this.offlineTrainingStaffService.signOutSubTask(param, Collections.singletonList(offlineTrainingStaff), LocalDateTime.now().getYear());
    }
}

