/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.provider;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.dy.dy.converter.DyCompanyConverter;
import cn.smarthse.dy.dy.dto.DyCompanyAddParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingCompanyEditParam;
import cn.smarthse.dy.dy.dto.offlineTraining.OfflineTrainingCompanyListParam;
import cn.smarthse.dy.dy.dto.workerTraining.WorkerTrainingChooseCompanyListParam;
import cn.smarthse.dy.dy.entity.DyCompany;
import cn.smarthse.dy.dy.entity.OfflineTrainingStaff;
import cn.smarthse.dy.dy.provider.IDyCompanyProviderService;
import cn.smarthse.dy.dy.service.dy.IDyCompanyService;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingStaffService;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingCompanyListVo;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingCompanyOneVo;
import cn.smarthse.dy.dy.vo.workerTraining.WorkerTrainingChooseCompanyListVo;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class DyCompanyProviderServiceImpl
implements IDyCompanyProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DyCompanyProviderServiceImpl.class);
    @Autowired
    private DyCompanyConverter dyCompanyConverter;
    @Autowired
    private IDyCompanyService dyCompanyService;
    @Autowired
    private IOfflineTrainingStaffService offlineTrainingStaffService;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;

    public boolean save(DyCompanyAddParam param) {
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getCompanyName(), null, Boolean.valueOf(true)).booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u4e0e\u6d59\u91cc\u536b\u4f01");
        }
        if (this.isHaveThisName(param.getCompanyName(), null).booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u4e8e\u7ebf\u4e0b\u57f9\u8bad\u4eba\u5458\u4e3b\u52a8\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u8bb0\u5f55");
        }
        DyCompany dyCompany = new DyCompany();
        dyCompany.setId(param.getCid());
        dyCompany.setName(param.getCompanyName());
        dyCompany.setDetailAreaId(param.getDetailAreaId());
        dyCompany.setIsHasCertificate(Boolean.valueOf(false));
        dyCompany.setIsStore(Boolean.valueOf(false));
        dyCompany.setStaffName(param.getName());
        dyCompany.setStaffTel(param.getTel());
        return this.dyCompanyService.save(dyCompany);
    }

    @Transactional
    public boolean deleteById(Long id) {
        if (Objects.isNull(id)) {
            return false;
        }
        DyCompany dyCompany = (DyCompany)this.dyCompanyService.getById(id);
        if (Objects.isNull(dyCompany)) {
            return false;
        }
        if (Boolean.TRUE.equals(dyCompany.getIsStore()) || Boolean.TRUE.equals(dyCompany.getIsHasCertificate())) {
            return false;
        }
        DyCompany update = new DyCompany();
        update.setId(id);
        update.setIsValid(Boolean.valueOf(false));
        return this.dyCompanyService.updateById(update);
    }

    public Boolean isHaveThisName(String name, Long excludeId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DyCompany::getName, (Object)name)).eq(DyCompany::getIsValid, (Object)true)).eq(DyCompany::getIsStore, (Object)false)).ne(Objects.nonNull(excludeId), DyCompany::getId, (Object)excludeId);
        return this.dyCompanyService.count((Wrapper)wrapper) > 0L;
    }

    public JqGridData<OfflineTrainingCompanyListVo> getList(OfflineTrainingCompanyListParam param) {
        PageInfo<OfflineTrainingCompanyListVo> rst = this.dyCompanyService.getPage(param);
        if (CollUtil.isEmpty((Collection)rst.getList())) {
            return new JqGridData(rst, (JqGridParam)param);
        }
        List industryList = this.industryProvideService.getIndustryByIds(rst.getList().stream().map(i -> String.valueOf(i.getIndustryCategory())).collect(Collectors.joining(",")));
        if (CollUtil.isNotEmpty((Collection)rst.getList())) {
            Map<Long, String> industryMap = industryList.stream().collect(Collectors.toMap(IndustryModel::getId, IndustryModel::getName, (v1, v2) -> v1));
            for (OfflineTrainingCompanyListVo row : rst.getList()) {
                if (!Objects.nonNull(row.getIndustryCategory())) continue;
                row.setIndustryCategoryName(industryMap.getOrDefault(row.getIndustryCategory(), ""));
            }
        }
        return new JqGridData(rst, (JqGridParam)param);
    }

    public JqGridData<CompanySuperviseModel> getQRCompanyList(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize) {
        companySearchVo.setSystemDeploymentSource(SystemDeploymentSourceEnum.DONG_YANG.getCode());
        PageInfo pageInfo = this.companyProvideBySuperviseService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(companySearchVo, pageNum, pageSize, Boolean.valueOf(true));
        PageInfo<CompanySuperviseModel> pageInfo2 = this.dyCompanyService.getQRCompanyPage(companySearchVo, pageNum, pageSize);
        pageInfo.getList().addAll(pageInfo2.getList());
        return new JqGridData(pageInfo, new JqGridParam(pageNum, pageSize));
    }

    public OfflineTrainingCompanyOneVo getOne(Long id) {
        IndustryModel industry;
        DyCompany dyCompany = (DyCompany)this.dyCompanyService.getById(id);
        if (Objects.isNull(dyCompany)) {
            return null;
        }
        OfflineTrainingCompanyOneVo rst = new OfflineTrainingCompanyOneVo().setId(dyCompany.getId()).setName(dyCompany.getName()).setUnifiedSocialCc(dyCompany.getUnifiedSocialCc()).setDetailAreaId(dyCompany.getDetailAreaId()).setIsStore(dyCompany.getIsStore());
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(dyCompany.getDetailAreaId());
        if (Objects.nonNull(area)) {
            rst.setDetailAreaName(area.getFullname(">"));
        }
        if (Objects.nonNull(industry = this.industryProvideService.getIndustryById(dyCompany.getIndustryCategory()))) {
            rst.setIndustryCategoryName(industry.getName());
        }
        return rst;
    }

    @Transactional
    public boolean update(OfflineTrainingCompanyEditParam param) {
        boolean b;
        DyCompany company = (DyCompany)this.dyCompanyService.getById(param.getId());
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        if (company.getIsStore().booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u5df2\u5165\u5e93\uff0c\u672c\u6a21\u5757\u65e0\u6cd5\u4fee\u6539\uff0c\u8bf7\u524d\u5f80\u5728\u7ebf\u57f9\u8bad\u6a21\u5757\u4e2d\u4fee\u6539");
        }
        if (this.companyProvideBySuperviseService.isHaveThisName(param.getName(), null, Boolean.valueOf(true)).booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u4e0e\u6d59\u91cc\u536b\u4f01");
        }
        if (this.isHaveThisName(param.getName(), param.getId()).booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u4e8e\u7ebf\u4e0b\u57f9\u8bad\u4eba\u5458\u4e3b\u52a8\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u8bb0\u5f55");
        }
        if (param.getUnifiedSocialCc().length() != 18) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        CompanySuperviseModel c = new CompanySuperviseModel();
        c.setId(param.getId());
        c.setName(param.getName());
        c.setUnifiedSocialCc(param.getUnifiedSocialCc());
        c.setAreaDetailId(param.getDetailAreaId());
        c.setIndustryCategory(param.getIndustryCategory());
        c.setDataSource(CompanyDataSourceEnum.OLINETRAIN.getValue());
        AreaModel area = this.sysAreaProvideService.getAreaById(param.getDetailAreaId());
        this.setSupervisionInfo(c, area);
        try {
            this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
        }
        catch (DuplicateKeyException e) {
            try {
                c.setId(Long.valueOf(IdWorker.getId()));
                this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByOne(c, param.getLoginUserId());
            }
            catch (Exception e2) {
                log.error("\u7ebf\u4e0b\u57f9\u8bad\u4eba\u5458\u4e3b\u52a8\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u4fdd\u5b58\u89e3\u51b3DuplicateKeyException\u5f02\u5e38", (Throwable)e2);
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u7ebf\u4e0b\u57f9\u8bad\u4eba\u5458\u4e3b\u52a8\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
        if (Objects.equals(param.getId(), c.getId())) {
            DyCompany dyCompany = new DyCompany();
            dyCompany.setId(param.getId());
            dyCompany.setName(param.getName());
            dyCompany.setUnifiedSocialCc(param.getUnifiedSocialCc());
            dyCompany.setDetailAreaId(param.getDetailAreaId());
            dyCompany.setIndustryCategory(param.getIndustryCategory());
            dyCompany.setIsStore(Boolean.valueOf(true));
            b = this.dyCompanyService.updateById(dyCompany);
        } else {
            LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(DyCompany::getId, (Object)c.getId())).set(DyCompany::getName, (Object)c.getName())).set(DyCompany::getUnifiedSocialCc, (Object)c.getUnifiedSocialCc())).set(DyCompany::getDetailAreaId, (Object)c.getAreaDetailId())).set(DyCompany::getIndustryCategory, (Object)c.getIndustryCategory())).set(DyCompany::getIsStore, (Object)true)).eq(DyCompany::getId, (Object)param.getId());
            b = this.dyCompanyService.update((Wrapper)wrapper);
            if (b) {
                LambdaUpdateWrapper wrapper2 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OfflineTrainingStaff::getCid, (Object)c.getId())).eq(OfflineTrainingStaff::getCid, (Object)param.getId());
                this.offlineTrainingStaffService.update((Wrapper)wrapper2);
            }
        }
        if (!b) {
            this.companyProvideBySuperviseService.rollbackImportCompanyAndCompanySuperviseData(Collections.singletonList(c.getId()));
        }
        return b;
    }

    private void setSupervisionInfo(CompanySuperviseModel c, AreaModel area) {
        Long areaId;
        if (Objects.equals(c.getBelongType(), CompanyBelongTypeEnum.SHI.getValue())) {
            areaId = area.getCityId();
        } else if (Objects.equals(c.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue())) {
            areaId = area.getProvinceId();
        } else {
            areaId = area.getAreaId();
            c.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        }
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (Objects.nonNull(org)) {
            c.setSupervisionUnit(org.getId());
            c.setSupervisionAreaId(org.getAreaId());
        }
    }

    @Transactional
    public void updateIsStoreSet0(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        this.dyCompanyService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(DyCompany::getIsStore, (Object)false)).in(DyCompany::getId, cidList));
    }

    public JqGridData<WorkerTrainingChooseCompanyListVo> getCompanyListForWorkerTraining(WorkerTrainingChooseCompanyListParam param) {
        return new JqGridData(this.dyCompanyService.getCompanyListForWorkerTraining(param), (JqGridParam)param);
    }
}

