/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.manager;

import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ExcelDataProcessor {
    private final OssClientBean ossClientBean;

    public String processExcel(MultipartFile file, Boolean ed) throws IOException {
        List<Map<Integer, String>> originalData = this.readExcel(file.getInputStream());
        List<Map<Integer, String>> transformedData = this.transformData(originalData, ed);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeExcelToStream(transformedData, outputStream);
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.supervise_05.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + String.valueOf(UUID.randomUUID()) + "-" + file.getOriginalFilename();
        String s = this.ossClientBean.OSSPutObject(uploadFile, file.getOriginalFilename(), (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        return this.ossClientBean.getUrl(s);
    }

    private List<Map<Integer, String>> readExcel(InputStream inputStream) {
        final ArrayList<Map<Integer, String>> dataList = new ArrayList<Map<Integer, String>>();
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().registerReadListener((ReadListener)new ReadListener<Map<Integer, String>>(){

            public void invoke(Map<Integer, String> data, AnalysisContext context) {
                dataList.add(data);
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
                System.out.println("Excel\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6210\uff0c\u5171" + dataList.size() + "\u884c\u6570\u636e");
            }
        })).doRead();
        return dataList;
    }

    private List<Map<Integer, String>> transformData(List<Map<Integer, String>> originalData, Boolean ed) {
        ArrayList<Map<Integer, String>> transformedData = new ArrayList<Map<Integer, String>>();
        for (Map<Integer, String> rowData : originalData) {
            HashMap<Integer, String> transformedRow = new HashMap<Integer, String>();
            for (Map.Entry<Integer, String> entry : rowData.entrySet()) {
                Integer columnIndex = entry.getKey();
                String originalValue = entry.getValue();
                String transformedValue = ed == true ? SpringEncryptUtils.decrypt((String)originalValue) : SpringEncryptUtils.encrypt((String)originalValue);
                transformedRow.put(columnIndex, transformedValue);
            }
            transformedData.add(transformedRow);
        }
        return transformedData;
    }

    private void writeExcel(HttpServletResponse response, List<Map<Integer, String>> data) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("transformed_data", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            ExcelWriterBuilder writerBuilder = EasyExcel.write((OutputStream)outputStream);
            ExcelWriterSheetBuilder sheetBuilder = writerBuilder.sheet("\u8f6c\u6362\u540e\u7684\u6570\u636e");
            sheetBuilder.doWrite(data);
        }
    }

    private void writeExcelToStream(List<Map<Integer, String>> dataList, ByteArrayOutputStream outputStream) {
        EasyExcel.write((OutputStream)outputStream).sheet("\u8f6c\u6362\u540e\u6570\u636e").doWrite(dataList);
    }

    @Generated
    public ExcelDataProcessor(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

