/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.crypto.digest.MD5;
import cn.smarthse.dy.dy.service.dy.IDyCompanyService;
import cn.smarthse.dy.dy.service.dy.IMasService;
import cn.smarthse.dy.dy.service.dy.IOfflineTrainingStaffService;
import cn.smarthse.dy.dy.vo.offlineTraining.OfflineTrainingCertificateVo;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainCertModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.font.FontProvider;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class CertificateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateManager.class);
    @Autowired
    private IOfflineTrainingStaffService offlineTrainingStaffService;
    @Autowired
    private IDyCompanyService dyCompanyService;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private IMasService masService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private ISyncTrainInfoService syncTrainInfoService;
    @Autowired
    private TemplateEngine templateEngine;
    private static final String FONT_MS_YH = "/templates/msyh.ttf";
    private static final String FONT_MS_YH_BOLD = "/templates/msyhbd.ttf";
    private static final String AUTHOR = "\u667a\u6167\u804c\u5b89\u73af\u4fdd\u79d1\u6280";
    private static final String CREATOR = "\u4e1c\u9633\u5e02\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u7cfb\u7edf";
    private static final String KEYWORDS = "\u7ebf\u4e0b\u57f9\u8bad\u8bc1\u4e66";
    private static final String TEMPLATE_PNG = "templates/cert.png";
    private static final String TEMPLATE_CERTIFICATE = "offlineTrainingCertificate";
    public static final String mobiles = "15068742413";

    private void generateCertificateV1Sub(Map<String, Object> dataMap, String templateName, String pdfFileName) {
        if (MapUtil.isEmpty(dataMap)) {
            return;
        }
        DateTime expiryDate = DateUtil.offsetMonth((Date)((Date)dataMap.get("signOutTime")), (int)12);
        Context context = new Context();
        dataMap.forEach((arg_0, arg_1) -> ((Context)context).setVariable(arg_0, arg_1));
        context.setVariable("signOutTimeStr", (Object)DateUtil.format((Date)((Date)dataMap.get("signOutTime")), (String)"yyyy-MM-dd"));
        context.setVariable("expiryDateStr", (Object)DateUtil.format((Date)expiryDate, (String)"yyyy-MM-dd"));
        String processedHtml = this.templateEngine.process(templateName, (IContext)context);
        String ossFileName = IdUtil.getSnowflakeNextIdStr() + "_" + FileUploadSimple.getNumberName((String)FileUtil.getSuffix((String)pdfFileName));
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.DY.getCode() + File.separator + UploadFilePathEnum.CERT.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator;
        String realPath = this.ossClientBean.getLocal() + uploadDir + ossFileName;
        String ossUrl = (uploadDir + ossFileName).replace("\\", "/");
        try {
            PdfWriter pdfWriter = new PdfWriter((OutputStream)FileUtil.getOutputStream((String)realPath));
            PdfDocument pdfDocument = new PdfDocument(pdfWriter);
            PageSize pageSize = PageSize.A4;
            pageSize = pageSize.rotate();
            pageSize.applyMargins(0.0f, 0.0f, 0.0f, 0.0f, true);
            pdfDocument.setDefaultPageSize(pageSize);
            pdfDocument.getDocumentInfo().setAuthor(AUTHOR).setCreator(CREATOR).setKeywords(KEYWORDS).setTitle(String.format("%s\u7684\u8bc1\u4e66", dataMap.get("name"))).setSubject(String.format("%s\u7684\u8bc1\u4e66", dataMap.get("name")));
            ConverterProperties properties = new ConverterProperties();
            DefaultFontProvider fontProvider = new DefaultFontProvider();
            fontProvider.addFont(FontProgramFactory.createFont((String)FONT_MS_YH));
            fontProvider.addFont(FontProgramFactory.createFont((String)FONT_MS_YH_BOLD));
            properties.setFontProvider((FontProvider)fontProvider);
            HtmlConverter.convertToPdf((String)processedHtml, (PdfDocument)pdfDocument, (ConverterProperties)properties);
        }
        catch (Exception e) {
            log.error("\u751f\u6210PDF\u65f6\u51fa\u9519\uff1a", (Throwable)e);
            return;
        }
        log.debug("\u751f\u6210PDF\u6210\u529f\uff0c\u8def\u5f84\uff1a{}", (Object)FileUtil.getAbsolutePath((String)ossFileName));
        SysFileModel file = new SysFileModel();
        file.setResource(Integer.valueOf(FileResourceEnum.DY.getValue()));
        file.setFileName(FileUtil.getPrefix((String)pdfFileName));
        file.setFileSize(String.valueOf(FileUtil.size((File)new File(pdfFileName))));
        file.setFileExt(FileUtil.getSuffix((String)pdfFileName));
        file.setFileHash(String.valueOf(MD5.create().digestHex(pdfFileName.getBytes())));
        file.setOssUrl(ossUrl);
        SysFileModel existSysFile = this.sysFileProvideService.getFileByHash(file.getFileHash());
        if (Objects.nonNull(existSysFile)) {
            file.setFullOssurl(existSysFile.getFullOssurl());
        }
        if (this.ossClientBean.isAsynch()) {
            log.debug("\u4e0a\u4f20\u8bc1\u4e66\u6587\u4ef6\uff1afileName:{}, ossUrl:{}", (Object)file.getFileName(), (Object)ossUrl);
            this.ossClientBean.OSSPutObject(ossFileName, new File(realPath), uploadDir, pdfFileName);
            log.debug("\u5220\u9664\u8bc1\u4e66\u6587\u4ef6\uff1a{}", (Object)realPath);
            FileUtil.del((String)realPath);
        }
        try {
            file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519\uff1a", (Throwable)e);
            return;
        }
        if (Objects.nonNull(file.getId())) {
            this.offlineTrainingStaffService.updateFileIdById(Convert.toLong((Object)dataMap.get("id")), file.getId());
            this.dyCompanyService.updateIsHasCertificateByCid(Boolean.TRUE, Convert.toLong((Object)dataMap.get("cid")));
            if (Boolean.TRUE == dataMap.get("isStore")) {
                TrainCertModel trainCertModel = new TrainCertModel();
                trainCertModel.setOnlineTrainId(Convert.toLong((Object)dataMap.get("id")));
                trainCertModel.setCid(Convert.toLong((Object)dataMap.get("cid")));
                trainCertModel.setStaffName(Convert.toStr((Object)dataMap.get("name")));
                trainCertModel.setTrainPersonnelType(Convert.toLong((Object)dataMap.get("trainPersonnelType")));
                trainCertModel.setCertNo(Convert.toStr((Object)dataMap.get("certificateNo")));
                trainCertModel.setCertCreateDate(Convert.toDate((Object)dataMap.get("signOutTime")));
                trainCertModel.setValidityDate((Date)expiryDate);
                trainCertModel.setFileId(file.getId());
                this.syncTrainInfoService.offlineCertSync(trainCertModel);
            }
        }
    }

    public void generateCertificateV1(List<Long> offlineTrainingStaffIdList) {
        if (CollUtil.isEmpty(offlineTrainingStaffIdList)) {
            return;
        }
        List<OfflineTrainingCertificateVo> list = this.offlineTrainingStaffService.getGeneralCertificateVoList(offlineTrainingStaffIdList);
        for (OfflineTrainingCertificateVo data : list) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("isStore", Objects.nonNull(data.getIsStore()) ? data.getIsStore() : true);
            dataMap.put("imgUrl", ResourceUtil.getResource((String)TEMPLATE_PNG));
            dataMap.put("name", data.getName());
            dataMap.put("gender", IdcardUtil.getGenderByIdCard((String)data.getIdCard()) == 1 ? "\u7537" : "\u5973");
            dataMap.put("idCard", data.getIdCard());
            dataMap.put("trainPersonnelTypeStr", data.getTrainPersonnelTypeStr());
            dataMap.put("signOutTime", data.getSignOutTime());
            dataMap.put("trainPublishUnit", "\u4e1c\u9633\u5e02\u536b\u751f\u5065\u5eb7\u5c40");
            dataMap.put("certificateNo", data.getCertificateNo());
            dataMap.put("id", data.getId());
            dataMap.put("cid", data.getCid());
            dataMap.put("trainPersonnelType", data.getTrainPersonnelType());
            this.generateCertificateV1Sub(dataMap, TEMPLATE_CERTIFICATE, String.format("%s\u7684\u8bc1\u4e66.pdf", data.getName()));
        }
    }
}

