/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.framework.handler;

import cn.smarthse.dy.dy.bootstrap.properties.JwtProperties;
import cn.smarthse.dy.dy.framework.handler.ApiJwtUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration
public class ApiHandlerInterceptor
implements HandlerInterceptor {
    private final JwtProperties jwtProperties;
    private final ObjectMapper objectMapper;

    public ApiHandlerInterceptor(JwtProperties jwtProperties, ObjectMapper objectMapper) {
        this.jwtProperties = jwtProperties;
        this.objectMapper = objectMapper;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String dy_token = request.getHeader(this.jwtProperties.getTokenName());
        if (dy_token == null) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), ResponseStateEnum.UNAUTHORIZED.getName()), (ServletResponse)response);
            return false;
        }
        if (!ApiJwtUtil.verify(dy_token, this.jwtProperties.getTokenSecret())) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName()), (ServletResponse)response);
            return false;
        }
        return true;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)this.objectMapper.writeValueAsString(data));
    }
}

