/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.controller.api;

import cn.smarthse.dy.dy.bootstrap.properties.JwtProperties;
import cn.smarthse.dy.dy.dto.api.AppKeyParam;
import cn.smarthse.dy.dy.service.api.IApiService;
import cn.smarthse.dy.dy.vo.api.ClientVo;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.web.core.ControllerSupport;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Validated
public class ApiController
extends ControllerSupport {
    private final IApiService apiService;
    private final JwtProperties jwtProperties;

    @PostMapping(value={"getToken"})
    public ResponseData<String> getToken(@Validated @RequestBody AppKeyParam param) {
        ClientVo client = this.apiService.getClient(param.getAppId());
        if (client == null) {
            return ResponseData.fail((String)"appId\u4e0d\u5b58\u5728\uff01");
        }
        if (!Objects.equals(client.getAppSecret(), param.getAppSecret())) {
            return ResponseData.fail((String)"appSecret\u9519\u8bef\uff01");
        }
        String token = JWT.create().withIssuer(this.jwtProperties.getIssuer()).withExpiresAt(DateUtils.addDays((Date)new Date(), (int)1)).withClaim("appId", param.getAppId()).sign(Algorithm.HMAC256((String)this.jwtProperties.getTokenSecret()));
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)token);
    }

    @Generated
    public ApiController(IApiService apiService, JwtProperties jwtProperties) {
        this.apiService = apiService;
        this.jwtProperties = jwtProperties;
    }
}

