/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.controller;

import cn.smarthse.dy.dy.manager.ExcelDataProcessor;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/encrypt"})
@Validated
public class EncryptController
extends ControllerSupport {
    private final ExcelDataProcessor excelDataProcessor;

    @GetMapping(value={"encryptHandler"})
    public String encryptHandler(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return SpringEncryptUtils.encrypt((String)s);
    }

    @GetMapping(value={"decryptHandler"})
    public String decryptHandler(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return SpringEncryptUtils.decrypt((String)s);
    }

    @PostMapping(value={"processExcel"})
    public String processExcel(@RequestParam(value="file") MultipartFile file, HttpServletResponse response, @RequestParam(value="ed", required=false, defaultValue="true") Boolean ed) throws IOException {
        if (file.isEmpty()) {
            response.sendError(400, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            response.sendError(400, "\u8bf7\u4e0a\u4f20Excel\u6587\u4ef6\uff08.xlsx\u6216.xls\u683c\u5f0f\uff09");
            return null;
        }
        return this.excelDataProcessor.processExcel(file, ed);
    }

    @Generated
    public EncryptController(ExcelDataProcessor excelDataProcessor) {
        this.excelDataProcessor = excelDataProcessor;
    }
}

