/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.dy.bootstrap;

import cn.smarthse.dy.dy.bootstrap.properties.JwtProperties;
import cn.smarthse.dy.dy.framework.handler.ApiHandlerInterceptor;
import cn.smarthse.framework.oss.config.properties.OssClientProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    private final OssClientProperties ossClientProperties;
    private final JwtProperties jwtProperties;
    private final ObjectMapper objectMapper;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"}).setCachePeriod(Integer.valueOf(3600)).resourceChain(true);
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + this.ossClientProperties.getLocal() + "upload/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ApiHandlerInterceptor(this.jwtProperties, this.objectMapper)).addPathPatterns(new String[]{"/api/**", "/bx/api/**", "/encrypt/**"}).excludePathPatterns(new String[]{"/api/getToken", "/bx/api/getToken"});
    }

    @Generated
    public MvcConfig(OssClientProperties ossClientProperties, JwtProperties jwtProperties, ObjectMapper objectMapper) {
        this.ossClientProperties = ossClientProperties;
        this.jwtProperties = jwtProperties;
        this.objectMapper = objectMapper;
    }
}

