/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.bx.service.impl;

import cn.smarthse.dy.bx.dao.BxPatrolMapper;
import cn.smarthse.dy.bx.param.BxPatrolQueryParam;
import cn.smarthse.dy.bx.param.BxPatrolStatusQueryParam;
import cn.smarthse.dy.bx.service.IBxPatrolService;
import cn.smarthse.dy.bx.vo.BxPatrolVo;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(readOnly=true)
@Service
public class BxPatrolServiceImpl
implements IBxPatrolService {
    private final BxPatrolMapper bxPatrolMapper;
    @DubboReference
    private ISysFileProvideService fileProvideService;

    @Override
    public PageInfo<BxPatrolVo> listFinishedPatrol(BxPatrolQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<BxPatrolVo> list = this.bxPatrolMapper.listFinishedPatrol(param);
        if (!CollectionUtils.isEmpty(list)) {
            List<Long> patrolFileIds = list.stream().map(BxPatrolVo::getPatrolFile).filter(Objects::nonNull).flatMap(patrolFile -> Arrays.stream(patrolFile.split(","))).map(String::trim).filter(s -> s.matches("\\d+")).map(Long::valueOf).distinct().toList();
            List<Long> unitManageSignIds = list.stream().map(BxPatrolVo::getUnitManageSign).filter(Objects::nonNull).distinct().toList();
            ArrayList<Long> fileIds = new ArrayList<Long>();
            fileIds.addAll(patrolFileIds);
            fileIds.addAll(unitManageSignIds);
            if (!CollectionUtils.isEmpty(fileIds)) {
                List fileList = this.fileProvideService.getListByIds(fileIds);
                Map<Long, SysFileModel> fileMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, item -> item, (v1, v2) -> v1));
                list.forEach(item -> {
                    SysFileModel sysFileModel;
                    if (item.getPatrolFile() != null) {
                        List<String> patrolFileIdList = Arrays.asList(item.getPatrolFile().split(","));
                        item.setPatrolFileUrl(patrolFileIdList.stream().map(String::trim).filter(s -> !s.isEmpty() && s.matches("\\d+")).map(Long::valueOf).map(fileMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
                    }
                    if (item.getUnitManageSign() != null && (sysFileModel = (SysFileModel)fileMap.get(item.getUnitManageSign())) != null) {
                        item.setUnitManageSignUrl(sysFileModel.getFullOssurl());
                    }
                });
            }
        }
        return new PageInfo(list);
    }

    @Override
    public Boolean getCompanyPatrolStatusByYear(BxPatrolStatusQueryParam param) {
        BxPatrolVo patrol = this.bxPatrolMapper.getCompanyFinishedPatrolByYear(param);
        return patrol != null;
    }

    @Generated
    public BxPatrolServiceImpl(BxPatrolMapper bxPatrolMapper) {
        this.bxPatrolMapper = bxPatrolMapper;
    }
}

