/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.dy.bx.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.dy.bx.dao.BxCompanyMapper;
import cn.smarthse.dy.bx.param.BxCompanyChangePushParam;
import cn.smarthse.dy.bx.param.BxCompanyChangeQueryParam;
import cn.smarthse.dy.bx.service.IBxCompanyChangeService;
import cn.smarthse.dy.bx.vo.BxCompanyVo;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopDataSourceEnums;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeForReasonEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeClueLastParam;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BxCompanyChangeServiceImpl
implements IBxCompanyChangeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BxCompanyChangeServiceImpl.class);
    private final BxCompanyMapper baseMapper;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean push(BxCompanyChangePushParam param) {
        SysAreaV3OneVo stopArea;
        List fileIdList;
        List repeatCidList;
        CompanyProposedChange entity;
        Boolean historicalData = param.getHistoricalData();
        String sourceId = param.getSourceId();
        Long cid = param.getCid();
        String contactName = param.getContactName();
        String contactTel = param.getContactTel();
        Integer stopType = param.getStopType();
        Integer reasonType = param.getReasonType();
        String fileIds = param.getFileIds();
        Long stopAreaId = param.getStopAreaId();
        String repeatCid = param.getRepeatCid();
        if (!(StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.CHANGECROSS.getCode().equals(stopType) || StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType) || StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType))) {
            throw new ServiceException("stopType\u53c2\u6570\u975e\u6cd5");
        }
        BxCompanyVo company = this.baseMapper.getOne(cid);
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728\u4e8e\u6d59\u91cc\u536b\u4f01");
        }
        LocalDateTime now = LocalDateTime.now();
        CompanyProposedChangeClueLastParam clueLastParam = new CompanyProposedChangeClueLastParam();
        clueLastParam.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
        clueLastParam.setCid(cid);
        if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CLOSE.getCode(), StopTypeEnums.NORMAL.getCode()));
        } else {
            clueLastParam.setStopTypeList(Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode()));
        }
        List clueList = this.companyProposedChangeProviderService.getClueList(clueLastParam);
        clueList = clueList.stream().filter(i -> StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(i.getStatus()) || StopStatusEnums.PROCESS.getCode().equals(i.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(clueList)) {
            Map<String, CompanyProposedChange> clueMap = clueList.stream().collect(Collectors.toMap(CompanyProposedChange::getSourceId, companyProposedChange -> companyProposedChange, (v1, v2) -> v2));
            entity = clueMap.get(sourceId);
            if (Objects.nonNull(entity)) {
                if (Objects.equals(entity.getSourceId(), sourceId)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u4f46\u65e0\u6cd5\u4fee\u6539\uff0c\u5f53\u524d\u5df2\u5b58\u5728\u7684sourceId\u4e3a %s\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s", entity.getSourceId(), StopStatusEnums.getName((Integer)entity.getStatus())), (Object)entity.getSourceId());
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setUpdateBy(Long.valueOf(-1L));
                    entity.setUpdateDate(now);
                    entity.setHistoricalData(historicalData);
                } else if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    if (!StopStatusEnums.PENDING_CONFIRMATION.getCode().equals(entity.getStatus())) throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u5f53\u524d\u5df2\u5b58\u5728\u7684sourceId\u4e3a %s\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u65e0\u6cd5\u65b0\u589e", entity.getSourceId(), StopStatusEnums.getName((Integer)entity.getStatus())), (Object)entity.getSourceId());
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(Long.valueOf(-1L));
                    entity.setCreateDate(now);
                    entity.setUpdateBy(Long.valueOf(-1L));
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                } else {
                    if (stopAreaId.equals(entity.getStopAreaId())) {
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), String.format("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u5f53\u524d\u5df2\u5b58\u5728\u7684sourceId\u4e3a %s\uff0c\u7ebf\u7d22\u72b6\u6001\u662f %s\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e", entity.getSourceId(), StopStatusEnums.getName((Integer)entity.getStatus())), (Object)entity.getSourceId());
                    }
                    entity = new CompanyProposedChange();
                    entity.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
                    entity.setSourceId(sourceId);
                    entity.setCid(cid);
                    entity.setStopType(stopType);
                    entity.setStopAreaId(stopAreaId);
                    entity.setReasonType(reasonType);
                    entity.setFileIds(fileIds);
                    entity.setRepeatCid(repeatCid);
                    entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                    entity.setConfirmTime(null);
                    entity.setContactName(contactName);
                    entity.setContactTel(contactTel);
                    entity.setCreateBy(Long.valueOf(-1L));
                    entity.setCreateDate(now);
                    entity.setUpdateBy(Long.valueOf(-1L));
                    entity.setUpdateDate(now);
                    entity.setIsValid(Boolean.valueOf(true));
                    entity.setHistoricalData(historicalData);
                }
            } else {
                if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    for (CompanyProposedChange existing : clueList) {
                        if (!stopType.equals(existing.getStopType())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                } else {
                    for (CompanyProposedChange existing : clueList) {
                        Integer existingStopType = existing.getStopType();
                        if (!StopTypeEnums.CHANGECROSS.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEWITHIN.getCode().equals(existingStopType) && !StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(existingStopType) || !stopAreaId.equals(existing.getStopAreaId())) continue;
                        throw new ServiceException(ResponseStateEnum.fail.getValue(), "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u4fe1\u606f\u53d8\u66f4\u7ebf\u7d22\uff0c\u53d8\u66f4\u5730\u5740\u76f8\u540c\uff0c\u65e0\u6cd5\u65b0\u589e");
                    }
                }
                entity = new CompanyProposedChange();
                entity.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
                entity.setSourceId(sourceId);
                entity.setCid(cid);
                entity.setStopType(stopType);
                entity.setStopAreaId(stopAreaId);
                entity.setReasonType(reasonType);
                entity.setFileIds(fileIds);
                entity.setRepeatCid(repeatCid);
                entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
                entity.setConfirmTime(null);
                entity.setContactName(contactName);
                entity.setContactTel(contactTel);
                entity.setCreateBy(Long.valueOf(-1L));
                entity.setCreateDate(now);
                entity.setUpdateBy(Long.valueOf(-1L));
                entity.setUpdateDate(now);
                entity.setIsValid(Boolean.valueOf(true));
                entity.setHistoricalData(historicalData);
            }
        } else {
            entity = new CompanyProposedChange();
            entity.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
            entity.setSourceId(sourceId);
            entity.setCid(cid);
            entity.setStopType(stopType);
            entity.setStopAreaId(stopAreaId);
            entity.setReasonType(reasonType);
            entity.setFileIds(fileIds);
            entity.setRepeatCid(repeatCid);
            entity.setStatus(StopStatusEnums.PENDING_CONFIRMATION.getCode());
            entity.setConfirmTime(null);
            entity.setContactName(contactName);
            entity.setContactTel(contactTel);
            entity.setCreateBy(Long.valueOf(-1L));
            entity.setCreateDate(now);
            entity.setUpdateBy(Long.valueOf(-1L));
            entity.setUpdateDate(now);
            entity.setIsValid(Boolean.valueOf(true));
            entity.setHistoricalData(historicalData);
        }
        if (Boolean.TRUE.equals(historicalData)) {
            if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                if (Objects.isNull(reasonType)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u539f\u56e0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!(StopTypeForReasonEnums.ONE.getCode().equals(reasonType) || StopTypeForReasonEnums.TWO.getCode().equals(reasonType) || StopTypeForReasonEnums.THREE.getCode().equals(reasonType) || StopTypeForReasonEnums.FOUR.getCode().equals(reasonType))) {
                    throw new ServiceException("reasonType\u53c2\u6570\u975e\u6cd5");
                }
                if (StopTypeForReasonEnums.TWO.getCode().equals(reasonType)) {
                    if (StrUtil.isBlank((CharSequence)repeatCid)) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    repeatCidList = StrUtil.split((CharSequence)repeatCid, (CharSequence)",");
                    if (CollUtil.isEmpty((Collection)repeatCidList)) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                    fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                    if (CollUtil.isEmpty((Collection)fileIdList)) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (fileIdList.size() > 3) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                    }
                }
                if (CompanyBusinessState.CLOSE.getCode().byteValue() == company.getBusinessState().byteValue()) {
                    entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                    entity.setConfirmTime(now);
                }
            } else if (StopTypeEnums.CHANGECROSS.getCode().equals(stopType)) {
                if (Objects.isNull(stopAreaId)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtil.isNotBlank((CharSequence)fileIds)) {
                    fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
                    if (CollUtil.isEmpty((Collection)fileIdList)) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (fileIdList.size() > 3) {
                        throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                    }
                }
                if (Objects.isNull(stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId))) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
                }
                if (stopAreaId != 0L && stopArea.getLevel() < 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
                }
                if (stopAreaId.equals(company.getAreaId())) {
                    entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                    entity.setConfirmTime(now);
                }
            } else if (StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType)) {
                if (Objects.isNull(stopAreaId)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
                stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId);
                if (Objects.isNull(stopArea)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
                }
                if (stopArea.getLevel() < 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
                }
                if (stopAreaId.equals(company.getAreaId())) {
                    entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                    entity.setConfirmTime(now);
                }
            } else if (StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType)) {
                if (Objects.isNull(stopAreaId)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
                }
                stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId);
                if (Objects.isNull(stopArea)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
                }
                if (stopArea.getLevel() < 4) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
                }
                if (stopAreaId.equals(company.getAreaId())) {
                    entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                    entity.setConfirmTime(now);
                }
            } else if (StopTypeEnums.NORMAL.getCode().equals(stopType) && CompanyBusinessState.NORMAL.getCode().byteValue() == company.getBusinessState().byteValue()) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(now);
            }
            try {
                entity.setBeforeAreaId(company.getAreaId());
                entity.setBeforeBusinessState(Integer.valueOf(company.getBusinessState().byteValue()));
                if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                    entity.setStopBusinessState(CompanyBusinessState.CLOSE.getCode());
                } else if (StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                    entity.setStopBusinessState(CompanyBusinessState.NORMAL.getCode());
                }
                this.companyProposedChangeProviderService.saveOrUpdate(entity);
                return true;
            }
            catch (Exception e) {
                log.error("\u536b\u751f\u76d1\u7763\u534f\u7ba1-\uff08\u65e2\u5f80\uff09\u4e0a\u62a5\u7528\u4eba\u5355\u4f4d\u4fe1\u606f\u53d8\u66f4\u60c5\u51b5\u5931\u8d25\uff1a", (Throwable)e);
                return false;
            }
        }
        if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
            if (Objects.isNull(reasonType)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u539f\u56e0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!(StopTypeForReasonEnums.ONE.getCode().equals(reasonType) || StopTypeForReasonEnums.TWO.getCode().equals(reasonType) || StopTypeForReasonEnums.THREE.getCode().equals(reasonType) || StopTypeForReasonEnums.FOUR.getCode().equals(reasonType))) {
                throw new ServiceException("reasonType\u53c2\u6570\u975e\u6cd5");
            }
            if (StopTypeForReasonEnums.TWO.getCode().equals(reasonType)) {
                if (StrUtil.isBlank((CharSequence)repeatCid)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                repeatCidList = StrUtil.split((CharSequence)repeatCid, (CharSequence)",");
                if (CollUtil.isEmpty((Collection)repeatCidList)) {
                    throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u91cd\u590d\u4f01\u4e1acid\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
            if (CollUtil.isEmpty((Collection)fileIdList)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            if (CompanyBusinessState.CLOSE.getCode().byteValue() == company.getBusinessState().byteValue()) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(now);
            }
        } else if (StopTypeEnums.CHANGECROSS.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)fileIds)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)",");
            if (CollUtil.isEmpty((Collection)fileIdList)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopAreaId != 0L && stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGECROSS.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
            if (stopAreaId.equals(company.getAreaId())) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(now);
            }
        } else if (StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u533a\u53bf\u7ea7\u522b");
            }
            area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
            if (stopAreaId != 0L && !Objects.equals(stopArea.getCityId(), area.getCityId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGEWITHIN.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u5fc5\u987b\u662f\u539f\u5740\u7684\u672c\u5e02\u8303\u56f4\u5185");
            }
            if (stopAreaId.equals(company.getAreaId())) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(now);
            }
        } else if (StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType)) {
            if (Objects.isNull(stopAreaId)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isNotBlank((CharSequence)fileIds) && CollUtil.isNotEmpty((Collection)(fileIdList = StrUtil.split((CharSequence)fileIds, (CharSequence)","))) && fileIdList.size() > 3) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u4f50\u8bc1\u6750\u6599\u6700\u591a\u4e09\u4efd");
            }
            stopArea = this.sysAreaProvideService.getAreaByIdV3(stopAreaId);
            if (Objects.isNull(stopArea)) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u4e0d\u5b58\u5728");
            }
            if (stopArea.getLevel() < 4) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.getNameByCode((Integer)stopType) + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
            }
            area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
            if (!Objects.equals(stopArea.getAreaId(), area.getAreaId())) {
                throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e3a" + StopTypeEnums.CHANGEDISTRICTWITHIN.getName() + "\u65f6\uff0c\u53d8\u66f4\u533a\u57df\u5fc5\u987b\u662f\u539f\u5740\u7684\u672c\u533a\u53bf\u8303\u56f4\u5185");
            }
            if (stopAreaId.equals(company.getAreaId())) {
                entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
                entity.setConfirmTime(now);
            }
        } else if (StopTypeEnums.NORMAL.getCode().equals(stopType) && CompanyBusinessState.NORMAL.getCode().byteValue() == company.getBusinessState().byteValue()) {
            entity.setStatus(StopStatusEnums.CONFIRMED.getCode());
            entity.setConfirmTime(now);
        }
        try {
            entity.setBeforeAreaId(company.getAreaId());
            entity.setBeforeBusinessState(Integer.valueOf(company.getBusinessState().byteValue()));
            if (StopTypeEnums.CLOSE.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.CLOSE.getCode());
            } else if (StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                entity.setStopBusinessState(CompanyBusinessState.NORMAL.getCode());
            }
            this.companyProposedChangeProviderService.saveOrUpdate(entity);
            return true;
        }
        catch (Exception e) {
            log.error("\u536b\u751f\u76d1\u7763\u534f\u7ba1-\u4e0a\u62a5\u7528\u4eba\u5355\u4f4d\u4fe1\u606f\u53d8\u66f4\u60c5\u51b5\u5931\u8d25\uff1a", (Throwable)e);
            return false;
        }
    }

    @Override
    public Integer getClueStatue(BxCompanyChangeQueryParam param) {
        CompanyProposedChangeClueLastParam clueLastParam = new CompanyProposedChangeClueLastParam();
        clueLastParam.setStopDataSource(StopDataSourceEnums.WSJDXG.getCode());
        clueLastParam.setSourceId(param.getSourceId());
        CompanyProposedChange entity = this.companyProposedChangeProviderService.getClueLast(clueLastParam);
        if (Objects.isNull(entity)) {
            throw new ServiceException("\u8be5\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        return entity.getStatus();
    }

    @Generated
    public BxCompanyChangeServiceImpl(BxCompanyMapper baseMapper) {
        this.baseMapper = baseMapper;
    }
}

